/*
 * Decompiled with CFR 0.152.
 */
package echopoint.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import echopoint.model.MapSection;
import echopoint.model.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="polygonSection")
public class PolygonSection
extends MapSection {
    private static final long serialVersionUID = 1L;
    private Collection<Point> vertices = new ArrayList<Point>();

    public PolygonSection() {
    }

    public PolygonSection(String ... values) {
        if (values.length > 0) {
            this.setActionCommand(values[0]);
        }
        if (values.length > 1) {
            this.setAltText(values[1]);
        }
    }

    public PolygonSection(int[] vertices, String ... values) {
        this(values);
        for (int i = 0; i < vertices.length; ++i) {
            if (i % 2 != 0) continue;
            if (i + 1 >= vertices.length) break;
            this.vertices.add(new Point(vertices[i], vertices[i + 1]));
        }
    }

    public PolygonSection(Collection<Point> vertices, String ... values) {
        this(values);
        this.setVertices(vertices);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PolygonSection that = (PolygonSection)o;
        return super.equals(o) && !(this.vertices == null ? that.vertices != null : !((Object)this.vertices).equals(that.vertices));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.vertices != null ? ((Object)this.vertices).hashCode() : 0);
        return result;
    }

    public Collection<Point> getVertices() {
        return Collections.unmodifiableCollection(this.vertices);
    }

    public void setVertices(Collection<Point> vertices) {
        this.vertices.clear();
        this.vertices.addAll(vertices);
    }
}

