/*
 * Decompiled with CFR 0.152.
 */
package echopoint.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import echopoint.model.MapSection;
import echopoint.model.Point;

@XStreamAlias(value="circleSection")
public class CircleSection
extends MapSection {
    private static final long serialVersionUID = 1L;
    private Point centre;
    private int radius;

    public CircleSection() {
    }

    public CircleSection(int x, int y, int radius, String ... values) {
        this(new Point(x, y), radius, values);
    }

    public CircleSection(Point centre, int radius, String ... values) {
        this.setCentre(centre);
        this.setRadius(radius);
        if (values.length > 0) {
            this.setActionCommand(values[0]);
        }
        if (values.length > 1) {
            this.setAltText(values[1]);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CircleSection that = (CircleSection)o;
        return super.equals(o) && this.radius == that.radius && !(this.centre == null ? that.centre != null : !this.centre.equals(that.centre));
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.centre != null ? this.centre.hashCode() : 0);
        result = 31 * result + this.radius;
        return result;
    }

    public Point getCentre() {
        return this.centre;
    }

    public void setCentre(Point centre) {
        this.centre = centre;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }
}

