/*
 * Decompiled with CFR 0.152.
 */
package echopoint.jquery;

import echopoint.able.Alignable;
import echopoint.able.Sizeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import nextapp.echo.app.Alignment;
import nextapp.echo.app.Border;
import nextapp.echo.app.Component;
import nextapp.echo.app.Extent;
import nextapp.echo.app.ImageReference;
import nextapp.echo.app.Insets;
import nextapp.echo.app.ResourceImageReference;

public class DateField
extends Component
implements Sizeable,
Alignable {
    protected static final Logger logger = Logger.getAnonymousLogger();
    public static final String DATE_CHANGED_PROPERTY = "date";
    public static final String PROPERTY_EDITABLE = "editable";
    public static final String PROPERTY_DATEFORMAT = "dateFormat";
    public static final String PROPERTY_USETIME = "useTime";
    public static final String PROPERTY_BORDER = "border";
    public static final String PROPERTY_CALENDAR_ICON = "icon";
    public static final String PROPERTY_CSS = "css";
    public static final String PROPERTY_INSETS = "insets";
    public static final String PROPERTY_LANGUAGE = "language";
    public static final ImageReference imageReference = new ResourceImageReference("/resource/images/calendar.gif");
    public static final String cssReference = DateField.getFileAsString("resource/js/jquery/calendar-win2k-cold-2.css");
    public static final String PROPERTY_INPUT_WIDTH = "inputWidth";
    public static final String PROPERTY_INPUT_HEIGHT = "inputHeight";
    private Date date;
    private String dateFormatPattern = "yyyy-MM-dd HH:mm";
    private SimpleDateFormat dateFormatter;

    public DateField() {
        this((Date)null);
    }

    public DateField(Calendar calendar) {
        this(calendar.getTime());
    }

    public DateField(Date date) {
        this.date = date;
        this.setDateFormat(this.dateFormatPattern);
        this.setIcon(imageReference);
        this.setCSS(cssReference);
    }

    private void appendPattern(StringBuffer datePattern, char currentChar, int numberOfThisChar) {
        switch (currentChar) {
            case 'y': {
                if (numberOfThisChar >= 3) {
                    datePattern.append("%").append("Y");
                    break;
                }
                datePattern.append("%").append("y");
                break;
            }
            case 'M': {
                if (numberOfThisChar >= 4) {
                    datePattern.append("%").append("B");
                }
                if (numberOfThisChar == 3) {
                    datePattern.append("%").append("b");
                    break;
                }
                datePattern.append("%").append("m");
                break;
            }
            case 'w': {
                datePattern.append("%").append("W");
                break;
            }
            case 'G': {
                throw new IllegalArgumentException("Era designator is not allowed");
            }
            case 'W': {
                throw new IllegalArgumentException("Week in month is not allowed");
            }
            case 'D': {
                datePattern.append("%").append("j");
                break;
            }
            case 'd': {
                datePattern.append("%").append("d");
                break;
            }
            case 'F': {
                throw new IllegalArgumentException("Day of week in month is not allowed");
            }
            case 'E': {
                if (numberOfThisChar > 3) {
                    datePattern.append("%").append("A");
                    break;
                }
                datePattern.append("%").append("a");
                break;
            }
            case 'a': {
                datePattern.append("%").append("p");
                break;
            }
            case 'H': {
                datePattern.append("%").append("H");
                break;
            }
            case 'k': {
                throw new IllegalArgumentException("Hour in day (1-24) is not allowed. Use 'H' instead.");
            }
            case 'K': {
                throw new IllegalArgumentException("Hour in am/pm (0-11) is not allowed. Use 'h' instead.");
            }
            case 'h': {
                datePattern.append("%").append("l");
                break;
            }
            case 'm': {
                datePattern.append("%").append("M");
                break;
            }
            case 's': {
                datePattern.append("%").append("S");
                break;
            }
            case 'S': {
                throw new IllegalArgumentException("Milliseconds is not allowed..");
            }
            case 'Z': 
            case 'z': {
                throw new IllegalArgumentException("Time zone is not allowed..");
            }
            default: {
                datePattern.append(currentChar);
            }
        }
    }

    private String convertDateFormat(String simpleDateFormat) {
        StringBuffer datePattern = new StringBuffer();
        char currentChar = '\u0000';
        int numberOfThisChar = 0;
        for (char ch : simpleDateFormat.toCharArray()) {
            if (currentChar == '\u0000') {
                currentChar = ch;
                numberOfThisChar = 1;
                continue;
            }
            if (ch == currentChar) {
                ++numberOfThisChar;
                continue;
            }
            this.appendPattern(datePattern, currentChar, numberOfThisChar);
            currentChar = ch;
            numberOfThisChar = 1;
        }
        this.appendPattern(datePattern, currentChar, numberOfThisChar);
        return datePattern.toString();
    }

    public void setDateFormat(String dateFormat) throws IllegalArgumentException {
        String jsDateFormatPattern = this.convertDateFormat(dateFormat);
        this.set(PROPERTY_DATEFORMAT, jsDateFormatPattern);
        this.dateFormatPattern = dateFormat;
        this.dateFormatter = new SimpleDateFormat(this.dateFormatPattern);
        if (jsDateFormatPattern.contains("%H") || jsDateFormatPattern.contains("%l")) {
            this.set(PROPERTY_USETIME, true);
        } else {
            this.set(PROPERTY_USETIME, false);
        }
    }

    public String getDateFormat() {
        return this.dateFormatPattern;
    }

    public void setInsets(Insets newValue) {
        this.set(PROPERTY_INSETS, newValue);
    }

    public Insets getInsets() {
        return (Insets)this.get(PROPERTY_INSETS);
    }

    public void setIcon(ImageReference newValue) {
        this.set(PROPERTY_CALENDAR_ICON, newValue);
    }

    public String getCSS() {
        return (String)this.get(PROPERTY_CSS);
    }

    public void setCSS(String newValue) {
        this.set(PROPERTY_CSS, newValue);
    }

    public Alignment getAlignment() {
        return (Alignment)this.get("alignment");
    }

    public void setAlignment(Alignment newValue) {
        this.set("alignment", newValue);
    }

    public ImageReference getIcon() {
        return (ImageReference)this.get(PROPERTY_CALENDAR_ICON);
    }

    public Border getBorder() {
        return (Border)this.get(PROPERTY_BORDER);
    }

    public void setWidth(Extent newValue) {
        this.set("width", newValue);
    }

    public Extent getWidth() {
        return (Extent)this.get("width");
    }

    public void setHeight(Extent newValue) {
        this.set("height", newValue);
    }

    public Extent getHeight() {
        return (Extent)this.get("height");
    }

    public Date getDate() {
        return this.date;
    }

    public String getDateStr() {
        if (this.date == null) {
            return null;
        }
        return this.dateFormatter.format(this.date);
    }

    public void processInput(String inputName, Object inputValue) {
        if (DATE_CHANGED_PROPERTY.equals(inputName) && inputValue != null) {
            try {
                this.setDate(this.dateFormatter.parse((String)inputValue));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    public void setBorder(Border newValue) {
        this.set(PROPERTY_BORDER, newValue);
    }

    public void setDate(Date newValue) {
        Date oldValue = this.date;
        this.date = newValue;
        this.firePropertyChange(DATE_CHANGED_PROPERTY, oldValue != null ? this.dateFormatter.format(oldValue) : null, this.dateFormatter.format(newValue));
    }

    public void setEditable(boolean newValue) {
        this.set(PROPERTY_EDITABLE, newValue);
    }

    public boolean isEditable() {
        Object property = this.get(PROPERTY_EDITABLE);
        return null == property ? true : (Boolean)property;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileAsString(String resource) {
        InputStreamReader in = null;
        StringBuffer sb = new StringBuffer();
        try {
            int character;
            in = new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream(resource));
            if (in == null) {
                throw new IllegalArgumentException("Specified resource does not exist: " + resource + ".");
            }
            while ((character = in.read()) != -1) {
                sb.append((char)character);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Could not load resource <" + resource + ">", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sb.toString();
    }

    public Extent getInputWidth() {
        return (Extent)this.get(PROPERTY_INPUT_WIDTH);
    }

    public void setInputWidth(Extent newValue) {
        this.set(PROPERTY_INPUT_WIDTH, newValue);
    }

    public Extent getInputHeight() {
        return (Extent)this.get(PROPERTY_INPUT_HEIGHT);
    }

    public void setInputHeight(Extent newValue) {
        this.set(PROPERTY_INPUT_HEIGHT, newValue);
    }
}

