/*
 * Decompiled with CFR 0.152.
 */
package echopoint.google.chart.model;

import echopoint.google.chart.model.ShapeMarker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartData<N extends Number>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Collection<N> xdata = new ArrayList<N>();
    private int xmax = -1;
    private Collection<N> ydata = new ArrayList<N>();
    private int ymax = -1;
    private String color;
    private String legend;
    private Collection<ShapeMarker> markers = new ArrayList<ShapeMarker>();

    public ChartData() {
    }

    public ChartData(Collection<N> xdata, int xmax) {
        this.setXdata(xdata);
        this.setXmax(xmax);
    }

    public Collection<N> getXdata() {
        return Collections.unmodifiableCollection(this.xdata);
    }

    public void setXdata(Collection<N> xdata) {
        this.xdata.clear();
        this.xdata.addAll(xdata);
        this.xmax = this.getXmax();
    }

    public int getXmax() {
        if (this.xmax > 0) {
            return this.xmax;
        }
        double max = 0.0;
        for (Number value : this.xdata) {
            if (value == null || !(value.doubleValue() > max)) continue;
            max = value.doubleValue();
        }
        return (int)max + 5;
    }

    public void setXmax(int xmax) {
        this.xmax = xmax;
    }

    public Collection<N> getYdata() {
        return Collections.unmodifiableCollection(this.ydata);
    }

    public void setYdata(Collection<N> ydata) {
        this.ydata.clear();
        this.ydata.addAll(ydata);
        this.ymax = this.getYmax();
    }

    public int getYmax() {
        if (this.ymax != -1) {
            return this.ymax;
        }
        double max = 0.0;
        for (Number value : this.ydata) {
            if (value == null || !(value.doubleValue() > max)) continue;
            max = value.doubleValue();
        }
        return (int)max + 5;
    }

    public void setYmax(int ymax) {
        this.ymax = ymax;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getLegend() {
        return this.legend;
    }

    public void setLegend(String legend) {
        this.legend = legend;
    }

    public Collection<ShapeMarker> getMarkers() {
        return this.markers;
    }

    public void setMarkers(Collection<ShapeMarker> markers) {
        this.markers.clear();
        this.markers.addAll(markers);
    }
}

