/*
 * Decompiled with CFR 0.152.
 */
package echopoint.google.chart.internal;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import echopoint.google.chart.internal.AbstractChart;
import echopoint.google.chart.model.Title;
import echopoint.internal.AbstractContainerPeer;
import nextapp.echo.app.Component;
import nextapp.echo.app.util.Context;
import nextapp.echo.webcontainer.ServerMessage;
import nextapp.echo.webcontainer.Service;
import nextapp.echo.webcontainer.WebContainerServlet;
import nextapp.echo.webcontainer.service.JavaScriptService;

public class AbstractChartPeer
extends AbstractContainerPeer {
    private static final String COMPONENT_NAME = AbstractChart.class.getName();
    protected static final XStream xstream;
    private static final String[] SERVICE_FILES;
    private static final Service COMPONENT_SERVICE;

    public void init(Context context, Component component) {
        super.init(context, component);
        ServerMessage serverMessage = (ServerMessage)context.get(ServerMessage.class);
        serverMessage.addLibrary(COMPONENT_NAME);
    }

    public Class getComponentClass() {
        return AbstractChart.class;
    }

    public String getClientComponentType(boolean shortType) {
        return COMPONENT_NAME;
    }

    public Object getOutputProperty(Context context, Component component, String propertyName, int propertyIndex) {
        if ("data".equals(propertyName) || "title".equals(propertyName)) {
            return xstream.toXML(component.get(propertyName));
        }
        return super.getOutputProperty(context, component, propertyName, propertyIndex);
    }

    static {
        SERVICE_FILES = new String[]{"resource/js/google/chart/Model.Google.js", "resource/js/google/chart/Application.Chart.js", "resource/js/google/chart/Sync.AbstractChart.js"};
        COMPONENT_SERVICE = JavaScriptService.forResources((String)COMPONENT_NAME, (String[])SERVICE_FILES);
        WebContainerServlet.getServiceRegistry().add(COMPONENT_SERVICE);
        xstream = new XStream((HierarchicalStreamDriver)new JsonHierarchicalStreamDriver());
        xstream.processAnnotations(Title.class);
        xstream.setMode(1001);
    }
}

