/*
 * Decompiled with CFR 0.152.
 */
package echopoint;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import echopoint.TagCloud;
import echopoint.internal.AbstractContainerPeer;
import echopoint.internal.DefaultEventPeer;
import echopoint.model.Tag;
import nextapp.echo.app.Component;
import nextapp.echo.app.util.Context;
import nextapp.echo.webcontainer.ServerMessage;
import nextapp.echo.webcontainer.Service;
import nextapp.echo.webcontainer.WebContainerServlet;
import nextapp.echo.webcontainer.service.JavaScriptService;

public class TagCloudPeer
extends AbstractContainerPeer {
    private static final String COMPONENT_NAME = TagCloud.class.getName();
    protected static final XStream xstream;
    private static final String[] SERVICE_FILES;
    private static final Service COMPONENT_SERVICE;

    public TagCloudPeer() {
        this.addEvent(new DefaultEventPeer("action", "actionListeners", String.class));
    }

    public void init(Context context, Component component) {
        super.init(context, component);
        ServerMessage serverMessage = (ServerMessage)context.get(ServerMessage.class);
        serverMessage.addLibrary(COMPONENT_NAME);
    }

    public Object getOutputProperty(Context context, Component component, String propertyName, int propertyIndex) {
        if ("tags".equals(propertyName)) {
            return xstream.toXML(((TagCloud)component).getData());
        }
        return super.getOutputProperty(context, component, propertyName, propertyIndex);
    }

    public Class getComponentClass() {
        return TagCloud.class;
    }

    public String getClientComponentType(boolean shortType) {
        return COMPONENT_NAME;
    }

    static {
        SERVICE_FILES = new String[]{"resource/js/Application.TagCloud.js", "resource/js/Sync.TagCloud.js"};
        COMPONENT_SERVICE = JavaScriptService.forResources((String)COMPONENT_NAME, (String[])SERVICE_FILES);
        WebContainerServlet.getServiceRegistry().add(COMPONENT_SERVICE);
        xstream = new XStream((HierarchicalStreamDriver)new JsonHierarchicalStreamDriver());
        xstream.processAnnotations(Tag.class);
        xstream.setMode(1001);
    }
}

