/*
 * Decompiled with CFR 0.152.
 */
package echopoint;

import echopoint.event.TagEvent;
import echopoint.internal.AbstractContainer;
import echopoint.model.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import nextapp.echo.app.Color;
import nextapp.echo.app.Component;
import nextapp.echo.app.event.ActionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagCloud
extends AbstractContainer {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_ROLLOVER_ENABLED = "rolloverEnabled";
    public static final String PROPERTY_ROLLOVER_BACKGROUND = "rolloverBackground";
    public static final String PROPERTY_ROLLOVER_FOREGROUND = "rolloverForeground";
    public static final String PROPERTY_TAGS = "tags";

    public boolean isValidChild(Component child) {
        return false;
    }

    public boolean getRolloverEnabled() {
        Boolean enabled = (Boolean)this.get(PROPERTY_ROLLOVER_ENABLED);
        return enabled != null ? enabled : false;
    }

    public void setRolloverEnabled(boolean enabled) {
        this.set(PROPERTY_ROLLOVER_ENABLED, enabled);
    }

    public Color getRolloverBackground() {
        return (Color)this.get(PROPERTY_ROLLOVER_BACKGROUND);
    }

    public void setRolloverBackground(Color background) {
        this.set(PROPERTY_ROLLOVER_BACKGROUND, background);
    }

    public Color getRolloverForeground() {
        return (Color)this.get(PROPERTY_ROLLOVER_FOREGROUND);
    }

    public void setRolloverForeground(Color foreground) {
        this.set(PROPERTY_ROLLOVER_FOREGROUND, foreground);
    }

    public Collection<Tag> getTags() {
        Map map = (Map)this.get(PROPERTY_TAGS);
        return Collections.unmodifiableCollection(map.values());
    }

    protected Collection<Tag> getData() {
        Map map = (Map)this.get(PROPERTY_TAGS);
        return new ArrayList<Tag>(map.values());
    }

    public Tag getTag(String name) {
        Map map = (Map)this.get(PROPERTY_TAGS);
        return (Tag)map.get(name);
    }

    public void setTags(Collection<Tag> tags) {
        LinkedHashMap<String, Tag> map = new LinkedHashMap<String, Tag>();
        for (Tag tag : tags) {
            map.put(tag.getName(), tag);
        }
        this.set(PROPERTY_TAGS, map);
    }

    @Override
    public void addActionListener(ActionListener listener) {
        super.addActionListener(listener);
    }

    @Override
    public void removeActionListener(ActionListener listener) {
        super.removeActionListener(listener);
    }

    @Override
    public boolean hasActionListeners() {
        return super.hasActionListeners();
    }

    public void processInput(String name, Object value) {
        super.processInput(name, value);
        if ("action".equals(name)) {
            Tag tag = this.getTag((String)value);
            this.fireActionPerformed(new TagEvent(this, tag.getName(), tag));
        }
    }
}

