/*
 * Decompiled with CFR 0.152.
 */
package echopoint;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import echopoint.ImageMap;
import echopoint.internal.AbstractContainerPeer;
import echopoint.internal.DefaultEventPeer;
import echopoint.model.CircleSection;
import echopoint.model.MapSection;
import echopoint.model.PolygonSection;
import echopoint.model.RectangleSection;
import java.util.LinkedHashMap;
import nextapp.echo.app.Component;
import nextapp.echo.app.update.ClientUpdateManager;
import nextapp.echo.app.util.Context;
import nextapp.echo.webcontainer.ServerMessage;
import nextapp.echo.webcontainer.Service;
import nextapp.echo.webcontainer.WebContainerServlet;
import nextapp.echo.webcontainer.service.JavaScriptService;

public class ImageMapPeer
extends AbstractContainerPeer {
    private static final String COMPONENT_NAME = ImageMap.class.getName();
    protected static final XStream xstream;
    private static final String[] SERVICE_FILES;
    private static final Service COMPONENT_SERVICE;

    public ImageMapPeer() {
        this.addEvent(new DefaultEventPeer("action", "actionListeners"));
    }

    public void init(Context context, Component component) {
        super.init(context, component);
        ServerMessage serverMessage = (ServerMessage)context.get(ServerMessage.class);
        serverMessage.addLibrary(COMPONENT_NAME);
    }

    public Class getComponentClass() {
        return ImageMap.class;
    }

    public String getClientComponentType(boolean shortType) {
        return COMPONENT_NAME;
    }

    public Class getInputPropertyClass(String propertyName) {
        if ("actionCommand".equals(propertyName)) {
            return String.class;
        }
        return super.getInputPropertyClass(propertyName);
    }

    public Object getOutputProperty(Context context, Component component, String propertyName, int propertyIndex) {
        if ("sections".equals(propertyName)) {
            return xstream.toXML(component.get("sections"));
        }
        return super.getOutputProperty(context, component, propertyName, propertyIndex);
    }

    public void storeInputProperty(Context context, Component component, String propertyName, int propertyIndex, Object newValue) {
        if ("actionCommand".equals(propertyName)) {
            ClientUpdateManager clientUpdateManager = (ClientUpdateManager)context.get(ClientUpdateManager.class);
            clientUpdateManager.setComponentProperty(component, "actionCommand", newValue);
        }
    }

    static {
        SERVICE_FILES = new String[]{"resource/js/Application.ImageMap.js", "resource/js/Sync.ImageMap.js"};
        COMPONENT_SERVICE = JavaScriptService.forResources((String)COMPONENT_NAME, (String[])SERVICE_FILES);
        WebContainerServlet.getServiceRegistry().add(COMPONENT_SERVICE);
        xstream = new XStream((HierarchicalStreamDriver)new JsonHierarchicalStreamDriver());
        xstream.processAnnotations(MapSection.class);
        xstream.processAnnotations(CircleSection.class);
        xstream.processAnnotations(PolygonSection.class);
        xstream.processAnnotations(RectangleSection.class);
        xstream.alias("list", LinkedHashMap.class);
        xstream.setMode(1001);
    }
}

