/*
 * Decompiled with CFR 0.152.
 */
package echopoint;

import com.thoughtworks.xstream.XStream;
import echopoint.internal.AbstractContainer;
import echopoint.model.MapSection;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import nextapp.echo.app.HttpImageReference;
import nextapp.echo.app.ImageReference;
import nextapp.echo.app.event.ActionEvent;
import nextapp.echo.app.event.ActionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageMap
extends AbstractContainer {
    private static final long serialVersionUID = 1L;
    protected static XStream xstream;
    public static final String PROPERTY_IMAGE = "url";
    public static final String PROPERTY_SECTIONS = "sections";
    protected String actionCommand;

    public ImageMap() {
    }

    public ImageMap(ImageReference image) {
        this.setImage(image);
    }

    public ImageMap(String url) {
        this.setImage(url);
    }

    public ImageReference getImage() {
        return (ImageReference)this.get(PROPERTY_IMAGE);
    }

    public void setImage(ImageReference image) {
        this.set(PROPERTY_IMAGE, image);
    }

    public void setImage(String url) {
        this.setImage((ImageReference)new HttpImageReference(url));
    }

    public Map<String, MapSection> getSections() {
        return Collections.unmodifiableMap((Map)this.get(PROPERTY_SECTIONS));
    }

    public void setSections(Map<String, MapSection> sections) {
        LinkedHashMap<String, MapSection> map = new LinkedHashMap<String, MapSection>(sections);
        this.set(PROPERTY_SECTIONS, map);
    }

    public void addSections(Collection<MapSection> sections) {
        LinkedHashMap<String, MapSection> map = (LinkedHashMap<String, MapSection>)this.get(PROPERTY_SECTIONS);
        if (map == null) {
            map = new LinkedHashMap<String, MapSection>();
        }
        for (MapSection section : sections) {
            if (section.getActionCommand() == null) continue;
            map.put(section.getActionCommand(), section);
        }
        this.setSections(map);
    }

    public void addSection(MapSection section) {
        if (section.getActionCommand() == null) {
            return;
        }
        LinkedHashMap<String, MapSection> map = (LinkedHashMap<String, MapSection>)this.get(PROPERTY_SECTIONS);
        if (map == null) {
            map = new LinkedHashMap<String, MapSection>();
        }
        map.put(section.getActionCommand(), section);
        this.setSections(map);
    }

    public void removeSection(MapSection section) {
        if (section.getActionCommand() == null) {
            return;
        }
        Map map = (Map)this.get(PROPERTY_SECTIONS);
        if (map != null) {
            map.remove(section.getActionCommand());
        }
        this.setSections(map);
    }

    public void removeAllSections() {
        this.setSections(new LinkedHashMap<String, MapSection>());
    }

    @Override
    public void setBackgroundImage(ImageReference backgroundImage) {
    }

    @Override
    public void addActionListener(ActionListener listener) {
        super.addActionListener(listener);
    }

    @Override
    public void removeActionListener(ActionListener listener) {
        super.removeActionListener(listener);
    }

    @Override
    public boolean hasActionListeners() {
        return super.hasActionListeners();
    }

    public void processInput(String name, Object value) {
        super.processInput(name, value);
        if ("actionCommand".equals(name)) {
            this.actionCommand = (String)value;
        }
        if ("action".equals(name)) {
            this.fireActionPerformed(new ActionEvent((Object)this, this.actionCommand));
        }
    }
}

