/*
 * Decompiled with CFR 0.152.
 */
package echopoint;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import echopoint.BorderLayout;
import echopoint.internal.AbstractContainerPeer;
import java.util.LinkedHashMap;
import nextapp.echo.app.Component;
import nextapp.echo.app.util.Context;
import nextapp.echo.webcontainer.ServerMessage;
import nextapp.echo.webcontainer.Service;
import nextapp.echo.webcontainer.WebContainerServlet;
import nextapp.echo.webcontainer.service.JavaScriptService;

public class BorderLayoutPeer
extends AbstractContainerPeer {
    private static final String COMPONENT_NAME = BorderLayout.class.getName();
    private static final String REGION_TO_INDEX = "regionToIndex";
    private static final String INDEX_TO_REGION = "indexToRegion";
    protected static final XStream xstream;
    private static final String[] SERVICE_FILES;
    private static final Service COMPONENT_SERVICE;

    public BorderLayoutPeer() {
        this.addOutputProperty(REGION_TO_INDEX);
        this.addOutputProperty(INDEX_TO_REGION);
    }

    public void init(Context context, Component component) {
        super.init(context, component);
        ServerMessage serverMessage = (ServerMessage)context.get(ServerMessage.class);
        serverMessage.addLibrary(COMPONENT_NAME);
    }

    public Object getOutputProperty(Context context, Component component, String propertyName, int propertyIndex) {
        if (REGION_TO_INDEX.equals(propertyName)) {
            return xstream.toXML(((BorderLayout)component).getRegionToIndex());
        }
        if (INDEX_TO_REGION.equals(propertyName)) {
            return xstream.toXML(((BorderLayout)component).getIndexToRegion());
        }
        return super.getOutputProperty(context, component, propertyName, propertyIndex);
    }

    public Class getComponentClass() {
        return BorderLayout.class;
    }

    public String getClientComponentType(boolean shortType) {
        return COMPONENT_NAME;
    }

    static {
        SERVICE_FILES = new String[]{"resource/js/Application.BorderLayout.js", "resource/js/Sync.BorderLayout.js"};
        COMPONENT_SERVICE = JavaScriptService.forResources((String)COMPONENT_NAME, (String[])SERVICE_FILES);
        WebContainerServlet.getServiceRegistry().add(COMPONENT_SERVICE);
        xstream = new XStream((HierarchicalStreamDriver)new JsonHierarchicalStreamDriver());
        xstream.alias("map", LinkedHashMap.class);
        xstream.setMode(1001);
    }
}

