/*
 * Decompiled with CFR 0.152.
 */
package echopoint;

import echopoint.internal.AbstractContainer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nextapp.echo.app.Component;
import nextapp.echo.app.IllegalChildException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BorderLayout
extends AbstractContainer {
    private static final long serialVersionUID = 1L;
    private Map<Region, Integer> regionToIndex = new LinkedHashMap<Region, Integer>(5);
    private Map<Integer, Region> indexToRegion = new LinkedHashMap<Integer, Region>(5);

    public BorderLayout() {
    }

    public BorderLayout(List<Component> list) {
        if (list.size() > 5) {
            throw new IllegalArgumentException("BorderLayout can contain only 5 child components");
        }
        if (list.size() == 1) {
            this.add(list.get(0));
        } else {
            for (int i = 0; i < list.size(); ++i) {
                Region region;
                switch (i) {
                    case 0: {
                        region = Region.north;
                        break;
                    }
                    case 1: {
                        region = Region.west;
                        break;
                    }
                    case 3: {
                        region = Region.east;
                        break;
                    }
                    case 4: {
                        region = Region.south;
                        break;
                    }
                    default: {
                        region = Region.center;
                    }
                }
                this.add(list.get(i), region);
            }
        }
    }

    public void add(Component component, Region region) {
        if (this.regionToIndex.containsKey((Object)region)) {
            throw new IllegalArgumentException("Component " + component + " illegally added to BorderLayout " + "at region: " + (Object)((Object)region));
        }
        int index = this.getComponentCount();
        super.add(component, index);
        this.regionToIndex.put(region, index);
        this.indexToRegion.put(index, region);
    }

    public void add(Component component, int index) throws IllegalChildException {
        if (index > 0) {
            throw new IllegalArgumentException("Component " + component + " illegally added to BorderLayout " + "at region: center");
        }
        this.add(component, Region.center);
    }

    public void add(Component component) {
        this.add(component, Region.center);
    }

    public Component getComponent(Region region) {
        if (!this.regionToIndex.containsKey((Object)region)) {
            return null;
        }
        return this.getComponent(this.regionToIndex.get((Object)region));
    }

    public void dispose() {
        this.regionToIndex.clear();
        this.indexToRegion.clear();
        super.dispose();
    }

    Map<Region, Integer> getRegionToIndex() {
        return this.regionToIndex;
    }

    Map<Integer, Region> getIndexToRegion() {
        return this.indexToRegion;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Region {
        north,
        west,
        center,
        east,
        south;

    }
}

