/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.pcbiznes.hibernate.database.mappings;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import pl.com.stream.pcbiznes.hibernate.database.mappings.Kartoteka;
import pl.com.stream.pcbiznes.hibernate.database.mappings.SklKoszykPoz;
import pl.com.stream.pcbiznes.hibernate.database.mappings.UrzZew;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SklKoszykNagl {
    private Date data;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private Integer id;
    private String idHttpSession;
    private Integer idOsobaKontrah;
    private Integer iloscPoz;
    private Collection<SklKoszykPoz> pozycje = new ArrayList<SklKoszykPoz>();
    private BigDecimal suma;

    public void addPozycje(Collection<SklKoszykPoz> collection) {
        for (SklKoszykPoz sklKoszykPoz : collection) {
            if (this.pozycje.contains(sklKoszykPoz)) {
                SklKoszykPoz sklKoszykPoz2 = this.getKoszykPozByKartoteka(sklKoszykPoz.getKartoteka());
                sklKoszykPoz2.setIlosc(sklKoszykPoz2.getIlosc().add(sklKoszykPoz.getIlosc()));
                sklKoszykPoz2.setUrzZew(sklKoszykPoz.getUrzZew());
                continue;
            }
            sklKoszykPoz.setSklKoszykNagl(this);
            this.pozycje.add(sklKoszykPoz);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SklKoszykNagl sklKoszykNagl = (SklKoszykNagl)object;
        if (this.data == null ? sklKoszykNagl.data != null : !this.data.equals(sklKoszykNagl.data)) {
            return false;
        }
        if (this.id == null ? sklKoszykNagl.id != null : !this.id.equals(sklKoszykNagl.id)) {
            return false;
        }
        if (this.idHttpSession == null ? sklKoszykNagl.idHttpSession != null : !this.idHttpSession.equals(sklKoszykNagl.idHttpSession)) {
            return false;
        }
        if (this.idOsobaKontrah == null ? sklKoszykNagl.idOsobaKontrah != null : !this.idOsobaKontrah.equals(sklKoszykNagl.idOsobaKontrah)) {
            return false;
        }
        if (this.iloscPoz == null ? sklKoszykNagl.iloscPoz != null : !this.iloscPoz.equals(sklKoszykNagl.iloscPoz)) {
            return false;
        }
        return !(this.suma == null ? sklKoszykNagl.suma != null : !this.suma.equals(sklKoszykNagl.suma));
    }

    public Date getData() {
        return this.data;
    }

    public Integer getId() {
        return this.id;
    }

    public String getIdHttpSession() {
        return this.idHttpSession;
    }

    public Integer getIdOsobaKontrah() {
        return this.idOsobaKontrah;
    }

    public Integer getIloscPoz() {
        return this.iloscPoz;
    }

    public SklKoszykPoz getKoszykPozById(Integer n) {
        for (SklKoszykPoz sklKoszykPoz : this.getPozycje()) {
            if (!n.equals(sklKoszykPoz.getId())) continue;
            return sklKoszykPoz;
        }
        return null;
    }

    public SklKoszykPoz getKoszykPozByKartoteka(Kartoteka kartoteka) {
        if (kartoteka == null) {
            return null;
        }
        for (SklKoszykPoz sklKoszykPoz : this.getPozycje()) {
            if (sklKoszykPoz.getKartoteka() == null || !kartoteka.getId().equals(sklKoszykPoz.getKartoteka().getId())) continue;
            return sklKoszykPoz;
        }
        return null;
    }

    public Collection<SklKoszykPoz> getPozycje() {
        return this.pozycje;
    }

    public List<SklKoszykPoz> getPozycje(UrzZew urzZew) {
        if (urzZew == null) {
            return null;
        }
        if (urzZew.getId() == null) {
            return null;
        }
        ArrayList<SklKoszykPoz> arrayList = null;
        for (SklKoszykPoz sklKoszykPoz : this.pozycje) {
            if (!urzZew.getId().equals(sklKoszykPoz.getUrzZew().getId())) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<SklKoszykPoz>();
            }
            arrayList.add(sklKoszykPoz);
        }
        return arrayList;
    }

    public BigDecimal getSuma() {
        return this.suma;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.data == null ? 0 : this.data.hashCode());
        n = 31 * n + (this.id == null ? 0 : this.id.hashCode());
        n = 31 * n + (this.idHttpSession == null ? 0 : this.idHttpSession.hashCode());
        n = 31 * n + (this.idOsobaKontrah == null ? 0 : this.idOsobaKontrah.hashCode());
        n = 31 * n + (this.iloscPoz == null ? 0 : this.iloscPoz.hashCode());
        n = 31 * n + (this.suma == null ? 0 : this.suma.hashCode());
        return n;
    }

    public void setData(Date date) {
        this.data = date;
    }

    public void setId(Integer n) {
        this.id = n;
    }

    public void setIdHttpSession(String string) {
        this.idHttpSession = string;
    }

    public void setIdOsobaKontrah(Integer n) {
        this.idOsobaKontrah = n;
    }

    public void setIloscPoz(Integer n) {
        this.iloscPoz = n;
    }

    public void setPozycje(Collection<SklKoszykPoz> collection) {
        this.pozycje = collection;
    }

    public void setSuma(BigDecimal bigDecimal) {
        this.suma = bigDecimal;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Naglowek koszyka:\n");
        stringBuffer.append("id: ").append(this.id).append(", ");
        stringBuffer.append("id httpsession: ").append(this.idHttpSession).append(", ");
        stringBuffer.append("id osobakontrah: ").append(this.idOsobaKontrah).append(", ");
        stringBuffer.append("data: ").append(this.dateFormat.format(this.data)).append(", ");
        stringBuffer.append("suma: ").append(this.suma).append(", ");
        if (this.getPozycje().size() > 0) {
            stringBuffer.append("pozycje(").append(this.iloscPoz).append("):\n");
            for (SklKoszykPoz sklKoszykPoz : this.getPozycje()) {
                stringBuffer.append("\t- " + sklKoszykPoz).append("\n");
            }
        }
        return stringBuffer.toString();
    }
}

