/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.pcbiznes.hibernate.database.dao;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Property;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.lib.hibernate.dao.HibernateDAO;
import pl.com.stream.lib.hibernate.exception.DAOException;
import pl.com.stream.pcbiznes.hibernate.database.mappings.ZdarzenieCrmOsKtr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZdarzenieCrmOsKtrDAO
extends HibernateDAO<ZdarzenieCrmOsKtr> {
    private static Logger log = Logger.getLogger(ZdarzenieCrmOsKtrDAO.class);
    private static final long serialVersionUID = -2205860614370226434L;

    public ZdarzenieCrmOsKtr changeOsobaKontrah(Integer n, Integer n2) throws DAOException {
        List<ZdarzenieCrmOsKtr> list = this.getList(n);
        switch (list.size()) {
            case 0: {
                return this.create(n2, n);
            }
            case 1: {
                try {
                    log.debug((Object)MessageFormat.format(Res.changingPerson, n, n2));
                    ZdarzenieCrmOsKtr zdarzenieCrmOsKtr = list.get(0);
                    String string = "UPDATE ZDARZENIECRMOSKTR crmOs SET crmOs.ID_OSOBAKONTRAH = ? WHERE crmOs.ID_ZDARZENIECRM = ? AND crmOs.ID_OSOBAKONTRAH = ?";
                    this.beginTransaction();
                    SQLQuery sQLQuery = this.getSession().createSQLQuery(string);
                    sQLQuery.setParameter(0, (Object)n2);
                    sQLQuery.setParameter(1, (Object)n);
                    sQLQuery.setParameter(2, (Object)zdarzenieCrmOsKtr.getId().getIdOsobaKontrah());
                    sQLQuery.executeUpdate();
                    this.commitTransaction();
                    return zdarzenieCrmOsKtr;
                }
                catch (HibernateException hibernateException) {
                    String string = MessageFormat.format(Res.changingPersonFailed, hibernateException.getMessage());
                    log.error((Object)string, (Throwable)hibernateException);
                    this.rollbackTransaction();
                    throw new DAOException(string, (Throwable)hibernateException);
                }
            }
        }
        throw new DAOException(Res.informationTitle, Res.changingPersonFailedTooManyPersons);
    }

    public ZdarzenieCrmOsKtr create(Integer n, Integer n2) throws DAOException {
        try {
            log.debug((Object)MessageFormat.format(Res.creatingPersonEvent, n));
            this.beginTransaction();
            ZdarzenieCrmOsKtr zdarzenieCrmOsKtr = new ZdarzenieCrmOsKtr(n, n2);
            this.getSession().saveOrUpdate((Object)zdarzenieCrmOsKtr);
            this.commitTransaction();
            return zdarzenieCrmOsKtr;
        }
        catch (HibernateException hibernateException) {
            String string = MessageFormat.format(Res.creatingPersonEventFailed, hibernateException.getMessage());
            log.error((Object)string, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string, (Throwable)hibernateException);
        }
    }

    public ZdarzenieCrmOsKtr get(Integer n, Integer n2) throws DAOException {
        if (n == null) {
            return null;
        }
        if (n2 == null) {
            return null;
        }
        try {
            log.debug((Object)MessageFormat.format(Res.gettingPersonEvent, n2, n));
            this.beginTransaction();
            ZdarzenieCrmOsKtr.Id id = new ZdarzenieCrmOsKtr.Id(n, n2);
            ZdarzenieCrmOsKtr zdarzenieCrmOsKtr = null;
            zdarzenieCrmOsKtr = (ZdarzenieCrmOsKtr)this.getSession().get(ZdarzenieCrmOsKtr.class, (Serializable)id);
            this.commitTransaction();
            return zdarzenieCrmOsKtr;
        }
        catch (HibernateException hibernateException) {
            String string = MessageFormat.format(Res.gettingPersonEventFailed, hibernateException.getMessage());
            log.error((Object)string, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string, (Throwable)hibernateException);
        }
    }

    public List<ZdarzenieCrmOsKtr> getList(Integer n) throws DAOException {
        if (n == null) {
            return null;
        }
        List list = null;
        try {
            log.debug((Object)MessageFormat.format(Res.gettingPersonEventList, n));
            this.beginTransaction();
            list = this.getSession().createCriteria(ZdarzenieCrmOsKtr.class).add((Criterion)Property.forName((String)"id.idZdarzenieCrm").eq((Object)n)).list();
            this.commitTransaction();
            return list;
        }
        catch (HibernateException hibernateException) {
            String string = MessageFormat.format(Res.gettingPersonEventListFailed, hibernateException.getMessage());
            log.error((Object)string, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string, (Throwable)hibernateException);
        }
    }

    static {
        ResourceManager.bind(ZdarzenieCrmOsKtrDAO.class);
    }

    @ResourceContainer
    private static class Res {
        private static String changingPerson;
        private static String changingPersonFailed;
        private static String changingPersonFailedTooManyPersons;
        private static String creatingPersonEvent;
        private static String creatingPersonEventFailed;
        private static String gettingPersonEvent;
        private static String gettingPersonEventFailed;
        private static String gettingPersonEventList;
        private static String gettingPersonEventListFailed;
        private static String informationTitle;

        private Res() {
        }
    }
}

