/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.pcbiznes.hibernate.database.dao;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Property;
import org.hibernate.exception.GenericJDBCException;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.lib.hibernate.dao.HibernateDAO;
import pl.com.stream.lib.hibernate.exception.DAOException;
import pl.com.stream.pcbiznes.hibernate.database.mappings.ZdarzenieCrm;
import pl.com.stream.pcbiznes.hibernate.database.mappings.ZdarzenieCrmDokument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZdarzenieCrmDAO
extends HibernateDAO<ZdarzenieCrm> {
    private static Logger log = Logger.getLogger(ZdarzenieCrmDAO.class);
    private static final long serialVersionUID = 3398793942957093060L;
    private final String SQL_CALL_ZDARZENIE_CRM_ADD = "{call ZDARZENIE_CRM_ADD(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)}";

    public Integer create(Integer n, String string, String string2, Integer n2, Integer n3, Integer n4) throws DAOException {
        try {
            log.debug((Object)Res.creatingEvent);
            this.beginTransaction();
            Connection connection = this.getSession().connection();
            CallableStatement callableStatement = connection.prepareCall("{call ZDARZENIE_CRM_ADD(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)}");
            callableStatement.setInt(1, (int)n);
            callableStatement.setString(2, string);
            callableStatement.setString(3, string2);
            callableStatement.setInt(4, 2);
            callableStatement.setInt(5, (int)n2);
            callableStatement.setNull(6, 4);
            callableStatement.setInt(7, (int)n3);
            callableStatement.setInt(8, (int)n4);
            callableStatement.setNull(9, 4);
            callableStatement.setNull(10, 93);
            callableStatement.setNull(11, 93);
            callableStatement.setNull(12, 93);
            callableStatement.setNull(13, 93);
            callableStatement.setInt(14, 0);
            callableStatement.setInt(15, 1);
            callableStatement.setInt(16, 2);
            callableStatement.setNull(17, 93);
            callableStatement.setNull(18, 93);
            callableStatement.setInt(19, 0);
            callableStatement.setNull(20, 93);
            ResultSet resultSet = callableStatement.executeQuery();
            int n5 = -1;
            int n6 = 9;
            if (resultSet.next()) {
                n5 = resultSet.getInt(1);
                n6 = resultSet.getInt(2);
            }
            resultSet.close();
            callableStatement.close();
            if (n6 == 0) {
                log.debug((Object)MessageFormat.format(Res.eventCreated, n5));
                this.commitTransaction();
                return n5;
            }
            this.rollbackTransaction();
            String string3 = null;
            switch (n6) {
                case 1: {
                    string3 = Res.eventCreationFailedError1;
                    break;
                }
                case 2: {
                    string3 = Res.eventCreationFailedError2;
                    break;
                }
                case 3: {
                    string3 = Res.eventCreationFailedError3;
                    break;
                }
                default: {
                    string3 = MessageFormat.format(Res.eventCreationFailedError, n6);
                }
            }
            log.debug((Object)string3);
            throw new DAOException(Res.informationTitle, string3);
        }
        catch (Exception exception) {
            String string4 = MessageFormat.format(Res.creatingEventFailed, exception.getMessage());
            log.error((Object)string4, (Throwable)exception);
            this.rollbackTransaction();
            throw new DAOException(string4, (Throwable)exception);
        }
    }

    public void delete(Integer n) throws DAOException {
        if (n == null) {
            return;
        }
        try {
            log.debug((Object)MessageFormat.format(Res.removingEvent, n));
            this.beginTransaction();
            this.getSession().createSQLQuery("DELETE FROM ZDARZENIECRM crm WHERE crm.ID_ZDARZENIECRM = " + n).executeUpdate();
            this.commitTransaction();
        }
        catch (HibernateException hibernateException) {
            Object object;
            this.rollbackTransaction();
            if (hibernateException instanceof GenericJDBCException) {
                object = (GenericJDBCException)hibernateException;
                switch (object.getErrorCode()) {
                    case 335544466: {
                        throw new DAOException(Res.informationTitle, Res.removingEventFailedConstraintViolation);
                    }
                }
            }
            object = MessageFormat.format(Res.removingEventFailed, hibernateException.getMessage());
            log.error(object, (Throwable)hibernateException);
            throw new DAOException((String)object, (Throwable)hibernateException);
        }
    }

    public ZdarzenieCrm get(Integer n, Integer[] integerArray) throws DAOException {
        if (n == null) {
            return null;
        }
        ZdarzenieCrm zdarzenieCrm = null;
        try {
            log.debug((Object)MessageFormat.format(Res.gettingEvent, n));
            this.beginTransaction();
            if (integerArray != null) {
                this.getSession().enableFilter("cechy").setParameterList("idCech", (Object[])integerArray);
            }
            zdarzenieCrm = (ZdarzenieCrm)this.getSession().get(ZdarzenieCrm.class, (Serializable)n);
            this.commitTransaction();
            return zdarzenieCrm;
        }
        catch (HibernateException hibernateException) {
            String string = MessageFormat.format(Res.gettingEventFailed, hibernateException.getMessage());
            log.error((Object)string, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string, (Throwable)hibernateException);
        }
    }

    public List<ZdarzenieCrmDokument> getDokumentList(Integer n, Integer n2) throws DAOException {
        if (n == null) {
            return null;
        }
        List list = null;
        try {
            log.debug((Object)MessageFormat.format(Res.gettingDocumentList, n));
            this.beginTransaction();
            list = this.getSession().createCriteria(ZdarzenieCrmDokument.class).add((Criterion)Property.forName((String)"idTypZdarzCrm").eq((Object)n2)).add((Criterion)Property.forName((String)"idZdarzenieCrmNad").eq((Object)n)).addOrder(Order.asc((String)"nazwaZdarz")).list();
            this.commitTransaction();
            return list;
        }
        catch (HibernateException hibernateException) {
            String string = MessageFormat.format(Res.gettingDocumentListFailed, hibernateException.getMessage());
            log.error((Object)string, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string, (Throwable)hibernateException);
        }
    }

    static {
        ResourceManager.bind(ZdarzenieCrmDAO.class);
    }

    @ResourceContainer
    private static class Res {
        public static String creatingEventFailed;
        private static String creatingEvent;
        private static String eventCreated;
        private static String eventCreationFailedError;
        private static String eventCreationFailedError1;
        private static String eventCreationFailedError2;
        private static String eventCreationFailedError3;
        private static String gettingDocumentList;
        private static String gettingDocumentListFailed;
        private static String gettingEvent;
        private static String gettingEventFailed;
        private static String informationTitle;
        private static String removingEvent;
        private static String removingEventFailed;
        private static String removingEventFailedConstraintViolation;

        private Res() {
        }
    }
}

