/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.pcbiznes.hibernate.database.dao;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Property;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.lib.hibernate.dao.HibernateDAO;
import pl.com.stream.lib.hibernate.exception.DAOException;
import pl.com.stream.pcbiznes.hibernate.database.mappings.WystCechOsobaKontrah;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WystCechOsobaKontrahDAO
extends HibernateDAO<WystCechOsobaKontrah> {
    private static Logger log = Logger.getLogger(WystCechOsobaKontrahDAO.class);
    private static final long serialVersionUID = 2211554239258232804L;

    public WystCechOsobaKontrah create(Integer n, Integer n2, String string) throws DAOException {
        if (n == null) {
            return null;
        }
        if (n2 == null) {
            return null;
        }
        try {
            log.debug((Object)MessageFormat.format(Res.creatingFeatureValue, n2, n));
            this.beginTransaction();
            WystCechOsobaKontrah.Id id = new WystCechOsobaKontrah.Id(n, n2);
            WystCechOsobaKontrah wystCechOsobaKontrah = new WystCechOsobaKontrah();
            wystCechOsobaKontrah.setId(id);
            wystCechOsobaKontrah.setWartosc(string);
            this.getSession().saveOrUpdate((Object)wystCechOsobaKontrah);
            this.commitTransaction();
            return wystCechOsobaKontrah;
        }
        catch (HibernateException hibernateException) {
            String string2 = MessageFormat.format(Res.creatingFeatureValueFailed, hibernateException.getMessage());
            log.error((Object)string2, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string2, (Throwable)hibernateException);
        }
    }

    public WystCechOsobaKontrah get(Integer n, Integer n2) throws DAOException {
        if (n == null) {
            return null;
        }
        if (n2 == null) {
            return null;
        }
        try {
            log.debug((Object)MessageFormat.format(Res.gettingFeatureValue, n2, n));
            this.beginTransaction();
            WystCechOsobaKontrah.Id id = new WystCechOsobaKontrah.Id(n, n2);
            WystCechOsobaKontrah wystCechOsobaKontrah = (WystCechOsobaKontrah)this.getSession().get(WystCechOsobaKontrah.class, (Serializable)id);
            this.commitTransaction();
            return wystCechOsobaKontrah;
        }
        catch (HibernateException hibernateException) {
            String string = MessageFormat.format(Res.gettingFeatureValueFailed, hibernateException.getMessage());
            log.error((Object)string, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string, (Throwable)hibernateException);
        }
    }

    public List<WystCechOsobaKontrah> getList(Integer n, String string) throws DAOException {
        if (n == null) {
            return null;
        }
        try {
            log.debug((Object)MessageFormat.format(Res.gettingPersonListWithFeatureValue, n, string));
            List list = null;
            this.beginTransaction();
            list = this.getSession().createCriteria(WystCechOsobaKontrah.class).add((Criterion)Property.forName((String)"id.idCecha").eq((Object)n)).add((Criterion)Property.forName((String)"wartosc").eq((Object)string)).list();
            this.commitTransaction();
            return list;
        }
        catch (HibernateException hibernateException) {
            String string2 = MessageFormat.format(Res.gettingPersonListWithFeatureValueFailed, hibernateException.getMessage());
            log.error((Object)string2, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string2, (Throwable)hibernateException);
        }
    }

    public List<Integer> getList(Integer n, String string, Integer n2) throws DAOException {
        if (n == null) {
            return null;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            log.debug((Object)MessageFormat.format(Res.gettingPersonListFromThirdParty, n2, n, string));
            ArrayList<Integer> arrayList = null;
            this.beginTransaction();
            String string2 = "SELECT wyst.ID_OSOBAKONTRAH FROM WYSTCECHOSOBAKONTRAH wyst JOIN OSOBAKONTRAH os ON (os.ID_OSOBAKONTRAH = wyst.ID_OSOBAKONTRAH) JOIN ODDZIALKONTRAH odd ON (odd.ID_ODDZIALKONTRAH = os.ID_ODDZIALKONTRAH AND odd.ID_KONTRAH = ?) WHERE wyst.ID_CECHA = ? AND wyst.WARTOSC = ?";
            preparedStatement = this.getSession().connection().prepareStatement(string2);
            preparedStatement.setInt(1, n2);
            preparedStatement.setInt(2, n);
            preparedStatement.setString(3, string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                if (arrayList == null) {
                    arrayList = new ArrayList<Integer>();
                }
                arrayList.add(resultSet.getInt(1));
            }
            resultSet.close();
            preparedStatement.close();
            this.commitTransaction();
            return arrayList;
        }
        catch (Exception exception) {
            String string3 = MessageFormat.format(Res.gettingPersonListFromThirdPartyFailed, exception.getMessage());
            log.error((Object)string3, (Throwable)exception);
            this.rollbackTransaction();
            throw new DAOException(string3, (Throwable)exception);
        }
    }

    public void setCechaForOnlyOneOsobaFromKontrah(Integer n, Integer n2, Integer n3, String string, String string2) throws DAOException {
        if (n == null) {
            return;
        }
        if (n2 == null) {
            return;
        }
        if (n3 == null) {
            return;
        }
        try {
            log.debug((Object)MessageFormat.format(Res.settingFeatureValueForOnlyOnePerson, n3, n, n2));
            String string3 = "UPDATE WYSTCECHOSOBAKONTRAH wyst SET wyst.WARTOSC=? WHERE wyst.ID_OSOBAKONTRAH in (SELECT os.ID_OSOBAKONTRAH FROM OSOBAKONTRAH os JOIN ODDZIALKONTRAH odd ON (odd.id_oddzialkontrah = os.id_oddzialkontrah AND odd.id_kontrah = ?)) AND wyst.id_cecha=? AND wyst.wartosc <> ?";
            this.beginTransaction();
            SQLQuery sQLQuery = this.getSession().createSQLQuery(string3);
            sQLQuery.setParameter(0, (Object)string2);
            sQLQuery.setParameter(1, (Object)n2);
            sQLQuery.setParameter(2, (Object)n3);
            sQLQuery.setParameter(3, (Object)string2);
            sQLQuery.executeUpdate();
            this.commitTransaction();
            this.create(n, n3, string);
        }
        catch (HibernateException hibernateException) {
            String string4 = MessageFormat.format(Res.settingFeatureValueForOnlyOnePersonFailed, hibernateException.getMessage());
            log.error((Object)string4, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string4, (Throwable)hibernateException);
        }
    }

    static {
        ResourceManager.bind(WystCechOsobaKontrahDAO.class);
    }

    @ResourceContainer
    private static class Res {
        private static String creatingFeatureValue;
        private static String creatingFeatureValueFailed;
        private static String gettingFeatureValue;
        private static String gettingFeatureValueFailed;
        private static String gettingPersonListFromThirdParty;
        private static String gettingPersonListFromThirdPartyFailed;
        private static String gettingPersonListWithFeatureValue;
        private static String gettingPersonListWithFeatureValueFailed;
        private static String settingFeatureValueForOnlyOnePerson;
        private static String settingFeatureValueForOnlyOnePersonFailed;

        private Res() {
        }
    }
}

