/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.pcbiznes.hibernate.database.dao;

import java.text.MessageFormat;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.lib.hibernate.dao.HibernateDAO;
import pl.com.stream.lib.hibernate.exception.DAOException;
import pl.com.stream.pcbiznes.hibernate.database.mappings.Wersja;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WersjaDAO
extends HibernateDAO<Wersja> {
    private static Logger log = Logger.getLogger(WersjaDAO.class);
    private static final long serialVersionUID = -2507620358131104877L;

    public Wersja get() throws DAOException {
        try {
            log.debug((Object)Res.gettingDatabaseVersion);
            this.beginTransaction();
            Wersja wersja = (Wersja)this.getSession().createCriteria(Wersja.class).uniqueResult();
            this.commitTransaction();
            return wersja;
        }
        catch (HibernateException hibernateException) {
            String string = MessageFormat.format(Res.gettingDatabaseVersionFailed, hibernateException.getMessage());
            log.error((Object)string, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string, (Throwable)hibernateException);
        }
    }

    public boolean isCorrectVersionOfPcBiznes(Integer n) throws DAOException {
        try {
            log.debug((Object)MessageFormat.format(Res.checkingDatabaseCompatibility, n));
            this.beginTransaction();
            Wersja wersja = (Wersja)this.getSession().createCriteria(Wersja.class).uniqueResult();
            this.commitTransaction();
            if (wersja == null) {
                return false;
            }
            return wersja.getNrWersji() >= n;
        }
        catch (HibernateException hibernateException) {
            String string = MessageFormat.format(Res.checkingDatabaseCompatibilityFailed, hibernateException.getMessage());
            log.error((Object)string, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string, (Throwable)hibernateException);
        }
    }

    static {
        ResourceManager.bind(WersjaDAO.class);
    }

    @ResourceContainer
    private static class Res {
        private static String checkingDatabaseCompatibility;
        private static String checkingDatabaseCompatibilityFailed;
        private static String gettingDatabaseVersion;
        private static String gettingDatabaseVersionFailed;

        private Res() {
        }
    }
}

