/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.pcbiznes.hibernate.database.dao;

import java.text.MessageFormat;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Property;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.lib.hibernate.dao.HibernateDAO;
import pl.com.stream.lib.hibernate.exception.DAOException;
import pl.com.stream.pcbiznes.hibernate.database.mappings.TypeMail;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeMailDAO
extends HibernateDAO<TypeMail> {
    private static Logger log = Logger.getLogger(TypeMailDAO.class);
    private static final long serialVersionUID = 1332057961418314029L;

    public TypeMail create(String string, boolean bl, boolean bl2) throws DAOException {
        try {
            log.debug((Object)MessageFormat.format(Res.creatingEmailType, string));
            this.beginTransaction();
            TypeMail typeMail = new TypeMail();
            typeMail.setNazwaTypu(string);
            typeMail.setAktywny(bl ? 1 : 0);
            typeMail.setDomyslny(bl2 ? 1 : 0);
            this.getSession().saveOrUpdate((Object)typeMail);
            this.commitTransaction();
            return typeMail;
        }
        catch (HibernateException hibernateException) {
            String string2 = MessageFormat.format(Res.creatingEmailTypeFailed, hibernateException.getMessage());
            log.error((Object)string2, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string2, (Throwable)hibernateException);
        }
    }

    public TypeMail get(String string) throws DAOException {
        if (string == null) {
            return null;
        }
        TypeMail typeMail = null;
        try {
            log.debug((Object)MessageFormat.format(Res.gettingEmailType, string));
            this.beginTransaction();
            typeMail = (TypeMail)this.getSession().createCriteria(TypeMail.class).add((Criterion)Property.forName((String)"nazwaTypu").eq((Object)string.toUpperCase()).ignoreCase()).uniqueResult();
            this.commitTransaction();
            return typeMail;
        }
        catch (HibernateException hibernateException) {
            String string2 = MessageFormat.format(Res.gettingEmailTypeFailed, hibernateException.getMessage());
            log.error((Object)string2, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string2, (Throwable)hibernateException);
        }
    }

    static {
        ResourceManager.bind(TypeMailDAO.class);
    }

    @ResourceContainer
    private static class Res {
        private static String creatingEmailType;
        private static String creatingEmailTypeFailed;
        private static String gettingEmailType;
        private static String gettingEmailTypeFailed;

        private Res() {
        }
    }
}

