/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.pcbiznes.hibernate.database.dao;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Property;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.lib.hibernate.dao.HibernateDAO;
import pl.com.stream.lib.hibernate.exception.DAOException;
import pl.com.stream.pcbiznes.hibernate.database.mappings.Kartoteka;
import pl.com.stream.pcbiznes.hibernate.database.mappings.SklKoszykNagl;
import pl.com.stream.pcbiznes.hibernate.database.mappings.SklKoszykPoz;
import pl.com.stream.pcbiznes.hibernate.database.mappings.UrzZew;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SklKoszykPozDAO
extends HibernateDAO<SklKoszykPoz> {
    private static Logger log = Logger.getLogger(SklKoszykPozDAO.class);
    private static final long serialVersionUID = -4877360978164075315L;

    public SklKoszykPoz create(SklKoszykNagl sklKoszykNagl, Kartoteka kartoteka, UrzZew urzZew, BigDecimal bigDecimal) throws DAOException {
        if (sklKoszykNagl == null) {
            return null;
        }
        if (kartoteka == null) {
            return null;
        }
        if (urzZew == null) {
            return null;
        }
        if (bigDecimal == null) {
            bigDecimal = new BigDecimal(1);
        }
        try {
            log.debug((Object)Res.creatingBasketPosition);
            this.beginTransaction();
            SklKoszykPoz sklKoszykPoz = new SklKoszykPoz();
            sklKoszykPoz.setSklKoszykNagl(sklKoszykNagl);
            sklKoszykPoz.setKartoteka(kartoteka);
            sklKoszykPoz.setUrzZew(urzZew);
            sklKoszykPoz.setIlosc(bigDecimal);
            this.getSession().save((Object)sklKoszykPoz);
            this.commitTransaction();
            return sklKoszykPoz;
        }
        catch (HibernateException hibernateException) {
            String string = MessageFormat.format(Res.creatingBasketPositionFailed, hibernateException.getMessage());
            log.error((Object)string, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string, (Throwable)hibernateException);
        }
    }

    public SklKoszykPoz get(SklKoszykNagl sklKoszykNagl, Integer n, UrzZew urzZew) throws DAOException {
        if (sklKoszykNagl == null) {
            return null;
        }
        if (n == null) {
            return null;
        }
        if (urzZew == null) {
            return null;
        }
        try {
            log.debug((Object)MessageFormat.format(Res.gettingBasketPosition, sklKoszykNagl.getId(), n, urzZew.getId()));
            this.beginTransaction();
            List list = this.getSession().createCriteria(SklKoszykPoz.class).add((Criterion)Property.forName((String)"sklKoszykNagl").eq((Object)sklKoszykNagl)).add((Criterion)Property.forName((String)"idKartoteka").eq((Object)n)).add((Criterion)Property.forName((String)"urzZew").eq((Object)urzZew)).list();
            SklKoszykPoz sklKoszykPoz = null;
            if (list.size() > 0) {
                sklKoszykPoz = (SklKoszykPoz)list.get(0);
                if (list.size() > 1) {
                    log.warn((Object)MessageFormat.format(Res.gettingBasketPositionWarrningTooMany, list.size()));
                }
            }
            if (sklKoszykPoz == null) {
                log.debug((Object)Res.gettingBasketPositionWarrningNotFound);
            }
            this.commitTransaction();
            return sklKoszykPoz;
        }
        catch (HibernateException hibernateException) {
            String string = MessageFormat.format(Res.gettingBasketPositionFailed, hibernateException.getMessage());
            log.error((Object)string, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string, (Throwable)hibernateException);
        }
    }

    public void save(SklKoszykPoz sklKoszykPoz, UrzZew urzZew, BigDecimal bigDecimal) throws DAOException {
        if (sklKoszykPoz == null) {
            return;
        }
        if (urzZew == null) {
            return;
        }
        if (bigDecimal == null) {
            return;
        }
        try {
            log.debug((Object)MessageFormat.format(Res.updatingBasketPosition, sklKoszykPoz.getId()));
            this.beginTransaction();
            sklKoszykPoz.setUrzZew(urzZew);
            sklKoszykPoz.setIlosc(bigDecimal);
            this.getSession().saveOrUpdate((Object)sklKoszykPoz);
            this.commitTransaction();
        }
        catch (HibernateException hibernateException) {
            String string = MessageFormat.format(Res.updatingBasketPositionFailed, hibernateException.getMessage());
            log.error((Object)string, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string, (Throwable)hibernateException);
        }
    }

    static {
        ResourceManager.bind(SklKoszykPozDAO.class);
    }

    @ResourceContainer
    private static class Res {
        private static String creatingBasketPosition;
        private static String creatingBasketPositionFailed;
        private static String gettingBasketPosition;
        private static String gettingBasketPositionFailed;
        private static String gettingBasketPositionWarrningNotFound;
        private static String gettingBasketPositionWarrningTooMany;
        private static String updatingBasketPosition;
        private static String updatingBasketPositionFailed;

        private Res() {
        }
    }
}

