/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.pcbiznes.hibernate.database.dao;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.lib.hibernate.dao.HibernateDAO;
import pl.com.stream.lib.hibernate.exception.DAOException;
import pl.com.stream.pcbiznes.hibernate.database.mappings.SklKoszykNagl;
import pl.com.stream.pcbiznes.hibernate.database.mappings.SklKoszykPoz;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SklKoszykNaglDAO
extends HibernateDAO<SklKoszykNagl> {
    private static Logger log = Logger.getLogger(SklKoszykNaglDAO.class);
    private static final long serialVersionUID = 4332552408290810252L;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public SklKoszykNagl create(Integer n, String string) throws DAOException {
        if (string == null) {
            return null;
        }
        try {
            log.debug((Object)Res.creatingHeader);
            this.beginTransaction();
            SklKoszykNagl sklKoszykNagl = new SklKoszykNagl();
            if (n != null) {
                sklKoszykNagl.setIdOsobaKontrah(n);
            }
            sklKoszykNagl.setIdHttpSession(string);
            sklKoszykNagl.setData(Calendar.getInstance().getTime());
            sklKoszykNagl.setIloscPoz(0);
            sklKoszykNagl.setSuma(new BigDecimal(0));
            this.getSession().save((Object)sklKoszykNagl);
            this.commitTransaction();
            return sklKoszykNagl;
        }
        catch (HibernateException hibernateException) {
            String string2 = MessageFormat.format(Res.creatingHeaderFailed, hibernateException.getMessage());
            log.error((Object)string2, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string2, (Throwable)hibernateException);
        }
    }

    public SklKoszykNagl create(String string) throws DAOException {
        return this.create(null, string);
    }

    public void delete(SklKoszykNagl sklKoszykNagl) throws DAOException {
        if (sklKoszykNagl == null) {
            return;
        }
        try {
            log.debug((Object)MessageFormat.format(Res.removingHeader, sklKoszykNagl.getId()));
            this.beginTransaction();
            String string = "delete from SklKoszykPoz where id_Skl_KoszykNagl = :idNagl";
            Query query = this.getSession().createQuery(string);
            query.setInteger("idNagl", sklKoszykNagl.getId().intValue());
            query.executeUpdate();
            sklKoszykNagl.getPozycje().clear();
            this.getSession().delete((Object)sklKoszykNagl);
            this.commitTransaction();
        }
        catch (HibernateException hibernateException) {
            String string = MessageFormat.format(Res.removingHeaderFailed, hibernateException.getMessage());
            log.error((Object)string, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string, (Throwable)hibernateException);
        }
    }

    public void deleteAllPoz(SklKoszykNagl sklKoszykNagl) throws DAOException {
        if (sklKoszykNagl == null) {
            return;
        }
        try {
            log.debug((Object)MessageFormat.format(Res.removingPositions, sklKoszykNagl.getId()));
            this.beginTransaction();
            String string = "delete from SklKoszykPoz where id_Skl_KoszykNagl = :idNagl";
            Query query = this.getSession().createQuery(string);
            query.setInteger("idNagl", sklKoszykNagl.getId().intValue());
            int n = query.executeUpdate();
            sklKoszykNagl.getPozycje().clear();
            this.commitTransaction();
            if (n > 0) {
                log.debug((Object)MessageFormat.format(Res.removedPositions, n, sklKoszykNagl.getId()));
            }
        }
        catch (HibernateException hibernateException) {
            String string = MessageFormat.format(Res.removingPositionsFailed, hibernateException.getMessage());
            log.error((Object)string, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string, (Throwable)hibernateException);
        }
    }

    public void deleteAllPrzetermNagl(Date date) throws DAOException {
        try {
            log.debug((Object)MessageFormat.format(Res.removingUnsedHeaders, this.dateFormat.format(date)));
            this.beginTransaction();
            String string = "select id from SklKoszykNagl where idOsobaKontrah is null and data <= :pdata";
            String string2 = "delete from SklKoszykPoz where id_Skl_KoszykNagl in (:pnagl)";
            String string3 = "delete from SklKoszykNagl where idOsobaKontrah is null and data <= :pdata";
            Query query = this.getSession().createQuery(string);
            query.setDate("pdata", date);
            List list = query.list();
            if (list.size() > 0) {
                Query query2 = this.getSession().createQuery(string2);
                query2.setParameterList("pnagl", (Collection)list);
                query2.executeUpdate();
                Query query3 = this.getSession().createQuery(string3);
                query3.setDate("pdata", date);
                query3.executeUpdate();
            }
            this.commitTransaction();
            list.clear();
            list = null;
        }
        catch (HibernateException hibernateException) {
            String string = MessageFormat.format(Res.removingUnsedHeadersFailed, hibernateException.getMessage());
            log.error((Object)string, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string, (Throwable)hibernateException);
        }
    }

    public void deleteFromSession(SklKoszykNagl sklKoszykNagl) throws DAOException {
        if (sklKoszykNagl == null) {
            return;
        }
        sklKoszykNagl.setIdHttpSession(null);
        this.save(sklKoszykNagl);
        super.deleteFromSession((Object)sklKoszykNagl);
        sklKoszykNagl.getPozycje().clear();
    }

    public SklKoszykNagl get(Integer n) throws DAOException {
        if (n == null) {
            return null;
        }
        try {
            log.debug((Object)MessageFormat.format(Res.gettingHeaderForPerson, n));
            this.beginTransaction();
            List list = this.getSession().createCriteria(SklKoszykNagl.class).add((Criterion)Property.forName((String)"idOsobaKontrah").eq((Object)n)).addOrder(Order.desc((String)"data")).addOrder(Order.desc((String)"id")).list();
            SklKoszykNagl sklKoszykNagl = null;
            if (list.size() > 0) {
                sklKoszykNagl = (SklKoszykNagl)list.get(0);
                if (list.size() > 1) {
                    log.warn((Object)MessageFormat.format(Res.gettingHeaderWarrningTooMany, list.size()));
                }
            }
            this.commitTransaction();
            return sklKoszykNagl;
        }
        catch (HibernateException hibernateException) {
            String string = MessageFormat.format(Res.gettingHeaderFailed, hibernateException.getMessage());
            log.error((Object)string, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string, (Throwable)hibernateException);
        }
    }

    public SklKoszykNagl get(Integer n, String string) throws DAOException {
        if (string == null) {
            return null;
        }
        try {
            log.debug((Object)MessageFormat.format(Res.gettingHeaderForPersonAndHttpSession, n, string));
            this.beginTransaction();
            List list = this.getSession().createCriteria(SklKoszykNagl.class).add((Criterion)Property.forName((String)"idOsobaKontrah").eq((Object)n)).add((Criterion)Property.forName((String)"idHttpSession").eq((Object)string)).addOrder(Order.desc((String)"data")).addOrder(Order.desc((String)"id")).list();
            SklKoszykNagl sklKoszykNagl = null;
            if (list.size() > 0) {
                sklKoszykNagl = (SklKoszykNagl)list.get(0);
                if (list.size() > 1) {
                    log.warn((Object)MessageFormat.format(Res.gettingHeaderWarrningTooMany, list.size()));
                }
            }
            this.commitTransaction();
            return sklKoszykNagl;
        }
        catch (HibernateException hibernateException) {
            String string2 = MessageFormat.format(Res.gettingHeaderFailed, hibernateException.getMessage());
            log.error((Object)string2, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string2, (Throwable)hibernateException);
        }
    }

    public SklKoszykNagl get(String string) throws DAOException {
        if (string == null) {
            return null;
        }
        try {
            log.debug((Object)MessageFormat.format(Res.gettingHeaderForHttpSession, string));
            this.beginTransaction();
            List list = this.getSession().createCriteria(SklKoszykNagl.class).add((Criterion)Property.forName((String)"idHttpSession").eq((Object)string)).addOrder(Order.desc((String)"data")).addOrder(Order.desc((String)"id")).list();
            SklKoszykNagl sklKoszykNagl = null;
            if (list.size() > 0) {
                sklKoszykNagl = (SklKoszykNagl)list.get(0);
                if (list.size() > 1) {
                    log.warn((Object)MessageFormat.format(Res.gettingHeaderWarrningTooMany, list.size()));
                }
            }
            this.commitTransaction();
            return sklKoszykNagl;
        }
        catch (HibernateException hibernateException) {
            String string2 = MessageFormat.format(Res.gettingHeaderFailed, hibernateException.getMessage());
            log.error((Object)string2, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string2, (Throwable)hibernateException);
        }
    }

    public void refreshAfterTriggers(SklKoszykNagl sklKoszykNagl) throws DAOException {
        if (sklKoszykNagl == null) {
            return;
        }
        try {
            Object[] objectArray;
            log.debug((Object)MessageFormat.format(Res.refreshingHeader, sklKoszykNagl.getId()));
            this.beginTransaction();
            List list = this.getSession().createCriteria(SklKoszykNagl.class).add((Criterion)Property.forName((String)"id").eq((Object)sklKoszykNagl.getId())).setProjection((Projection)Projections.projectionList().add((Projection)Property.forName((String)"suma")).add((Projection)Property.forName((String)"iloscPoz"))).list();
            this.commitTransaction();
            if (list.size() > 0 && (objectArray = (Object[])list.get(0)).length > 1) {
                Number number;
                if (objectArray[0] instanceof BigDecimal) {
                    number = (BigDecimal)objectArray[0];
                    sklKoszykNagl.setSuma((BigDecimal)number);
                }
                if (objectArray[1] instanceof Integer) {
                    number = (Integer)objectArray[1];
                    sklKoszykNagl.setIloscPoz((Integer)number);
                }
            }
        }
        catch (HibernateException hibernateException) {
            String string = MessageFormat.format(Res.refreshingHeaderFailed, hibernateException.getMessage());
            log.error((Object)string, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string, (Throwable)hibernateException);
        }
    }

    public SklKoszykNagl reload(SklKoszykNagl sklKoszykNagl, Integer n, String string) throws DAOException {
        try {
            if (sklKoszykNagl != null) {
                log.debug((Object)MessageFormat.format(Res.reloadingHeader, sklKoszykNagl.getId()));
            }
            SklKoszykNagl sklKoszykNagl2 = null;
            SklKoszykNagl sklKoszykNagl3 = this.get(n);
            if (sklKoszykNagl3 != null && sklKoszykNagl != null) {
                sklKoszykNagl2 = this.concat(sklKoszykNagl3, sklKoszykNagl);
            } else {
                SklKoszykNagl sklKoszykNagl4 = sklKoszykNagl != null ? sklKoszykNagl : (sklKoszykNagl2 = sklKoszykNagl3 != null ? sklKoszykNagl3 : null);
            }
            if (sklKoszykNagl2 != null) {
                sklKoszykNagl2.setData(Calendar.getInstance().getTime());
                sklKoszykNagl2.setIdHttpSession(string);
                sklKoszykNagl2.setIdOsobaKontrah(n);
                this.save(sklKoszykNagl2);
                this.refreshAfterTriggers(sklKoszykNagl);
            }
            return sklKoszykNagl2;
        }
        catch (HibernateException hibernateException) {
            String string2 = MessageFormat.format(Res.reloadingHeaderFailed, hibernateException.getMessage());
            log.error((Object)string2, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string2, (Throwable)hibernateException);
        }
    }

    private SklKoszykNagl concat(SklKoszykNagl sklKoszykNagl, SklKoszykNagl sklKoszykNagl2) throws DAOException {
        if (sklKoszykNagl.getPozycje().size() > 0) {
            this.copyPoz(sklKoszykNagl, sklKoszykNagl2);
        }
        this.delete(sklKoszykNagl);
        return sklKoszykNagl2;
    }

    private void copyPoz(SklKoszykNagl sklKoszykNagl, SklKoszykNagl sklKoszykNagl2) throws DAOException {
        Collection<SklKoszykPoz> collection = sklKoszykNagl.getPozycje();
        Collection<SklKoszykPoz> collection2 = sklKoszykNagl2.getPozycje();
        this.beginTransaction();
        for (SklKoszykPoz sklKoszykPoz : collection) {
            if (collection2.contains(sklKoszykPoz)) {
                SklKoszykPoz sklKoszykPoz2 = sklKoszykNagl2.getKoszykPozByKartoteka(sklKoszykPoz.getKartoteka());
                sklKoszykPoz2.setIlosc(sklKoszykPoz2.getIlosc().add(sklKoszykPoz.getIlosc()));
                sklKoszykPoz2.setUrzZew(sklKoszykPoz.getUrzZew());
                this.getSession().update((Object)sklKoszykPoz2);
                continue;
            }
            sklKoszykPoz.setSklKoszykNagl(sklKoszykNagl2);
            collection2.add(sklKoszykPoz);
            this.getSession().update((Object)sklKoszykPoz);
        }
        this.commitTransaction();
    }

    static {
        ResourceManager.bind(SklKoszykNaglDAO.class);
    }

    @ResourceContainer
    private static class Res {
        private static String creatingHeader;
        private static String creatingHeaderFailed;
        private static String gettingHeaderFailed;
        private static String gettingHeaderForHttpSession;
        private static String gettingHeaderForPerson;
        private static String gettingHeaderForPersonAndHttpSession;
        private static String gettingHeaderWarrningTooMany;
        private static String refreshingHeader;
        private static String refreshingHeaderFailed;
        private static String reloadingHeader;
        private static String reloadingHeaderFailed;
        private static String removedPositions;
        private static String removingHeader;
        private static String removingHeaderFailed;
        private static String removingPositions;
        private static String removingPositionsFailed;
        private static String removingUnsedHeaders;
        private static String removingUnsedHeadersFailed;

        private Res() {
        }
    }
}

