/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.pcbiznes.hibernate.database.dao;

import java.text.MessageFormat;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Property;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.lib.hibernate.dao.HibernateDAO;
import pl.com.stream.lib.hibernate.exception.DAOException;
import pl.com.stream.pcbiznes.hibernate.database.mappings.PrzenZdarzenieCrm;
import pl.com.stream.pcbiznes.hibernate.database.mappings.Uzytkownik;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrzenZdarzenieCrmDAO
extends HibernateDAO<PrzenZdarzenieCrm> {
    private static Logger log = Logger.getLogger(PrzenZdarzenieCrmDAO.class);
    private static final long serialVersionUID = 9195859604152026410L;

    public PrzenZdarzenieCrm create(Integer n, Uzytkownik uzytkownik, Uzytkownik uzytkownik2, String string) throws DAOException {
        try {
            log.debug((Object)MessageFormat.format(Res.creatingEventTransfer, n));
            this.beginTransaction();
            Integer n2 = this.getLp(n);
            PrzenZdarzenieCrm przenZdarzenieCrm = new PrzenZdarzenieCrm();
            przenZdarzenieCrm.setDataCzas(Calendar.getInstance().getTime());
            przenZdarzenieCrm.setIdZdarzenieCrm(n);
            przenZdarzenieCrm.setLp(n2);
            przenZdarzenieCrm.setOpis(string);
            przenZdarzenieCrm.setUzytkownik(uzytkownik);
            przenZdarzenieCrm.setUzytkownikWyk(uzytkownik2);
            this.getSession().saveOrUpdate((Object)przenZdarzenieCrm);
            this.commitTransaction();
            return przenZdarzenieCrm;
        }
        catch (HibernateException hibernateException) {
            String string2 = MessageFormat.format(Res.creatingEventTransferFailed, hibernateException.getMessage());
            log.error((Object)string2, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string2, (Throwable)hibernateException);
        }
    }

    public PrzenZdarzenieCrm get(Integer n) throws DAOException {
        if (n == null) {
            return null;
        }
        PrzenZdarzenieCrm przenZdarzenieCrm = null;
        try {
            log.debug((Object)MessageFormat.format(Res.gettingEventTransfer, n));
            this.beginTransaction();
            List list = this.getSession().createCriteria(PrzenZdarzenieCrm.class).add((Criterion)Property.forName((String)"idZdarzenieCrm").eq((Object)n)).addOrder(Order.desc((String)"lp")).list();
            if (list != null && list.size() > 0) {
                przenZdarzenieCrm = (PrzenZdarzenieCrm)list.get(0);
            }
            this.commitTransaction();
            return przenZdarzenieCrm;
        }
        catch (HibernateException hibernateException) {
            String string = MessageFormat.format(Res.gettingEventTransferFailed, hibernateException.getMessage());
            log.error((Object)string, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string, (Throwable)hibernateException);
        }
    }

    private Integer getLp(Integer n) throws HibernateException, DAOException {
        log.debug((Object)MessageFormat.format(Res.gettingHigestNumber, n));
        Integer n2 = 0;
        Query query = this.getSession().createQuery("select max(p.lp) from PrzenZdarzenieCrm p where p.idZdarzenieCrm = ?");
        query.setParameter(0, (Object)n);
        List list = query.list();
        if (list.size() > 0) {
            n2 = (Integer)list.get(0) + 1;
        }
        return n2;
    }

    static {
        ResourceManager.bind(PrzenZdarzenieCrmDAO.class);
    }

    @ResourceContainer
    private static class Res {
        private static String creatingEventTransfer;
        private static String creatingEventTransferFailed;
        private static String gettingEventTransfer;
        private static String gettingEventTransferFailed;
        private static String gettingHigestNumber;

        private Res() {
        }
    }
}

