/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.pcbiznes.hibernate.database.dao;

import java.text.MessageFormat;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.lib.hibernate.dao.HibernateDAO;
import pl.com.stream.lib.hibernate.exception.DAOException;
import pl.com.stream.pcbiznes.hibernate.database.mappings.DaneKontrah;
import pl.com.stream.pcbiznes.hibernate.database.mappings.Kontrah;
import pl.com.stream.pcbiznes.hibernate.database.mappings.OddzialKontrah;
import pl.com.stream.pcbiznes.hibernate.database.mappings.OsobaKontrah;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsobaKontrahDAO
extends HibernateDAO<OsobaKontrah> {
    private static Logger log = Logger.getLogger(OsobaKontrahDAO.class);
    private static final long serialVersionUID = 8079411468453366611L;

    public OsobaKontrah create(String string, String string2, String string3, String string4, OddzialKontrah oddzialKontrah, boolean bl) throws DAOException {
        return this.create(string, string2, string3, string4, oddzialKontrah, true, bl);
    }

    public OsobaKontrah create(String string, String string2, String string3, String string4, OddzialKontrah oddzialKontrah, boolean bl, boolean bl2) throws DAOException {
        try {
            log.debug((Object)Res.creatingPerson);
            OsobaKontrah osobaKontrah = new OsobaKontrah();
            osobaKontrah.setAktywny(bl2 ? 1 : 0);
            osobaKontrah.setImie(string);
            osobaKontrah.setNazwisko(string2);
            osobaKontrah.setLogZewAktywne(bl ? 1 : 0);
            osobaKontrah.setLogZewLogin(string3 == null ? null : string3.toUpperCase());
            osobaKontrah.setLogZewHaslo(string4 == null ? null : string4.toUpperCase());
            osobaKontrah.setOddzialKontrah(oddzialKontrah);
            this.beginTransaction();
            this.getSession().saveOrUpdate((Object)osobaKontrah);
            this.commitTransaction();
            return osobaKontrah;
        }
        catch (HibernateException hibernateException) {
            String string5 = MessageFormat.format(Res.creatingPersonFailed, hibernateException.getMessage());
            log.error((Object)string5, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string5, (Throwable)hibernateException);
        }
    }

    public OsobaKontrah get(String string, String string2) throws DAOException {
        if (string == null) {
            return null;
        }
        try {
            log.debug((Object)MessageFormat.format(Res.gettingPersonForLogin, string));
            this.beginTransaction();
            OsobaKontrah osobaKontrah = null;
            List list = this.getSession().createCriteria(OsobaKontrah.class).add((Criterion)Property.forName((String)"logZewLogin").eq((Object)string.toUpperCase()).ignoreCase()).add((Criterion)Property.forName((String)"aktywny").eq((Object)1)).add((Criterion)Property.forName((String)"logZewAktywne").eq((Object)1)).list();
            this.commitTransaction();
            switch (list.size()) {
                case 0: {
                    log.debug((Object)Res.personNotFound);
                    throw new DAOException(Res.informationTitle, Res.wrongLoginOrPassword);
                }
                case 1: {
                    osobaKontrah = (OsobaKontrah)list.get(0);
                    break;
                }
                default: {
                    log.warn((Object)MessageFormat.format(Res.tooManyPersonsFound, list.size()));
                    osobaKontrah = (OsobaKontrah)list.get(0);
                }
            }
            return osobaKontrah;
        }
        catch (HibernateException hibernateException) {
            String string3 = MessageFormat.format(Res.gettingPersonFailed, hibernateException.getMessage());
            log.error((Object)string3, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string3, (Throwable)hibernateException);
        }
    }

    public OsobaKontrah get(String string, String string2, OddzialKontrah oddzialKontrah) throws DAOException {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            return null;
        }
        if (oddzialKontrah == null) {
            return null;
        }
        try {
            log.debug((Object)MessageFormat.format(Res.gettingPerson, string, string2));
            this.beginTransaction();
            OsobaKontrah osobaKontrah = null;
            List list = this.getSession().createCriteria(OsobaKontrah.class).add((Criterion)Property.forName((String)"imie").eq((Object)string.toLowerCase()).ignoreCase()).add((Criterion)Property.forName((String)"nazwisko").eq((Object)string2.toLowerCase()).ignoreCase()).add((Criterion)Property.forName((String)"oddzialKontrah").eq((Object)oddzialKontrah)).list();
            this.commitTransaction();
            switch (list.size()) {
                case 0: {
                    log.debug((Object)Res.personNotFound);
                    break;
                }
                case 1: {
                    osobaKontrah = (OsobaKontrah)list.get(0);
                    break;
                }
                default: {
                    log.warn((Object)MessageFormat.format(Res.tooManyPersonsFound, list.size()));
                    osobaKontrah = (OsobaKontrah)list.get(0);
                }
            }
            return osobaKontrah;
        }
        catch (HibernateException hibernateException) {
            String string3 = MessageFormat.format(Res.gettingPersonFailed, hibernateException.getMessage());
            log.error((Object)string3, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string3, (Throwable)hibernateException);
        }
    }

    public OsobaKontrah getByEmail(String string, String string2) throws DAOException {
        if (string == null) {
            return null;
        }
        try {
            log.debug((Object)MessageFormat.format(Res.gettingPersonForEmail, string));
            this.beginTransaction();
            OsobaKontrah osobaKontrah = null;
            List list = this.getSession().createCriteria(OsobaKontrah.class).createAlias("emailOsobaKtr", "e").add((Criterion)Property.forName((String)"e.email").eq((Object)string.toUpperCase()).ignoreCase()).list();
            this.commitTransaction();
            switch (list.size()) {
                case 0: {
                    log.debug((Object)Res.personNotFound);
                    break;
                }
                case 1: {
                    osobaKontrah = (OsobaKontrah)list.get(0);
                    break;
                }
                default: {
                    for (OsobaKontrah osobaKontrah2 : list) {
                        DaneKontrah daneKontrah = osobaKontrah2.getOddzialKontrah().getKontrah().getAktualneDane();
                        String string3 = daneKontrah.getNipW();
                        if (string2 == null || !string2.replace("-", "").equals(string3)) continue;
                        return osobaKontrah2;
                    }
                }
            }
            return osobaKontrah;
        }
        catch (HibernateException hibernateException) {
            String string4 = MessageFormat.format(Res.gettingPersonFailed, hibernateException.getMessage());
            log.error((Object)string4, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string4, (Throwable)hibernateException);
        }
    }

    public List<OsobaKontrah> getList(Kontrah kontrah) throws DAOException {
        return this.getList(kontrah, true);
    }

    public List<OsobaKontrah> getList(Kontrah kontrah, boolean bl) throws DAOException {
        return this.getList(kontrah, null, bl);
    }

    public List<OsobaKontrah> getList(Kontrah kontrah, List<Order> list) throws DAOException {
        return this.getList(kontrah, list, true);
    }

    public List<OsobaKontrah> getList(Kontrah kontrah, List<Order> list, boolean bl) throws DAOException {
        List list2 = null;
        try {
            log.debug((Object)MessageFormat.format(Res.gettingPersonListForThirdParty, kontrah.getId()));
            this.beginTransaction();
            Criteria criteria = this.getSession().createCriteria(OsobaKontrah.class).createAlias("oddzialKontrah", "od").createAlias("od.kontrah", "k");
            if (bl) {
                criteria.add((Criterion)Property.forName((String)"logZewAktywne").eq((Object)1));
            }
            criteria.add((Criterion)Property.forName((String)"k.id").eq((Object)kontrah.getId()));
            if (list != null && list.size() > 0) {
                for (Order order : list) {
                    criteria.addOrder(order);
                }
            }
            list2 = criteria.list();
            this.commitTransaction();
            return list2;
        }
        catch (HibernateException hibernateException) {
            String string = MessageFormat.format(Res.gettingPersonListFailed, hibernateException.getMessage());
            log.error((Object)string, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string, (Throwable)hibernateException);
        }
    }

    public List<OsobaKontrah> getList(List<Integer> list) throws DAOException {
        return this.getList(list, null, false);
    }

    public List<OsobaKontrah> getList(List<Integer> list, List<Order> list2) throws DAOException {
        return this.getList(list, list2, false);
    }

    public List<OsobaKontrah> getList(List<Integer> list, List<Order> list2, boolean bl) throws DAOException {
        List list3 = null;
        try {
            log.debug((Object)MessageFormat.format(Res.gettingPersonList, list.toArray()));
            this.beginTransaction();
            Criteria criteria = this.getSession().createCriteria(OsobaKontrah.class).add(Property.forName((String)"id").in(list));
            if (bl) {
                criteria.add((Criterion)Property.forName((String)"logZewAktywne").eq((Object)1));
            }
            if (list2 != null && list2.size() > 0) {
                for (Order order : list2) {
                    criteria.addOrder(order);
                }
            }
            list3 = criteria.list();
            this.commitTransaction();
            return list3;
        }
        catch (HibernateException hibernateException) {
            String string = MessageFormat.format(Res.gettingPersonListFailed, hibernateException.getMessage());
            log.error((Object)string, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string, (Throwable)hibernateException);
        }
    }

    public boolean isLoginUsed(String string) throws DAOException {
        if (string == null) {
            return false;
        }
        try {
            log.debug((Object)MessageFormat.format(Res.isLoginUsed, string));
            this.beginTransaction();
            List list = this.getSession().createCriteria(OsobaKontrah.class).add((Criterion)Property.forName((String)"logZewLogin").eq((Object)string.toLowerCase()).ignoreCase()).setProjection((Projection)Projections.projectionList().add((Projection)Property.forName((String)"logZewLogin"))).list();
            this.commitTransaction();
            return list.size() > 0;
        }
        catch (HibernateException hibernateException) {
            String string2 = MessageFormat.format(Res.isLoginUsedFailed, hibernateException.getMessage());
            log.error((Object)string2, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string2, (Throwable)hibernateException);
        }
    }

    public OsobaKontrah search(String string) throws DAOException {
        if (string == null) {
            return null;
        }
        try {
            log.debug((Object)MessageFormat.format(Res.gettingPersonForLogin, string));
            this.beginTransaction();
            OsobaKontrah osobaKontrah = null;
            List list = this.getSession().createCriteria(OsobaKontrah.class).add((Criterion)Property.forName((String)"logZewLogin").eq((Object)string.toUpperCase()).ignoreCase()).list();
            this.commitTransaction();
            switch (list.size()) {
                case 0: {
                    log.debug((Object)Res.personNotFound);
                    break;
                }
                case 1: {
                    osobaKontrah = (OsobaKontrah)list.get(0);
                    break;
                }
                default: {
                    log.warn((Object)MessageFormat.format(Res.tooManyPersonsFound, list.size()));
                    osobaKontrah = (OsobaKontrah)list.get(0);
                }
            }
            return osobaKontrah;
        }
        catch (HibernateException hibernateException) {
            String string2 = MessageFormat.format(Res.gettingPersonFailed, hibernateException.getMessage());
            log.error((Object)string2, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string2, (Throwable)hibernateException);
        }
    }

    static {
        ResourceManager.bind(OsobaKontrahDAO.class);
    }

    @ResourceContainer
    private static class Res {
        private static String creatingPerson;
        private static String creatingPersonFailed;
        private static String gettingPerson;
        private static String gettingPersonFailed;
        private static String gettingPersonForLogin;
        private static String gettingPersonList;
        private static String gettingPersonListFailed;
        private static String gettingPersonListForThirdParty;
        private static String informationTitle;
        private static String isLoginUsed;
        private static String isLoginUsedFailed;
        private static String personNotFound;
        private static String tooManyPersonsFound;
        private static String wrongLoginOrPassword;
        private static String gettingPersonForEmail;

        private Res() {
        }
    }
}

