/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.pcbiznes.hibernate.database.dao;

import java.text.MessageFormat;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.lib.hibernate.dao.HibernateDAO;
import pl.com.stream.lib.hibernate.exception.DAOException;
import pl.com.stream.pcbiznes.hibernate.database.mappings.Kontrah;
import pl.com.stream.pcbiznes.hibernate.database.mappings.OddzialKontrah;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OddzialKontrahDAO
extends HibernateDAO<OddzialKontrah> {
    private static Logger log = Logger.getLogger(OddzialKontrahDAO.class);
    private static final long serialVersionUID = -3832687260247952785L;

    public OddzialKontrah create(Kontrah kontrah, String string, boolean bl, boolean bl2) throws DAOException {
        try {
            log.debug((Object)MessageFormat.format(Res.creatingDepartment, kontrah.getId()));
            OddzialKontrah oddzialKontrah = new OddzialKontrah();
            oddzialKontrah.setAktywny(bl ? 1 : 0);
            oddzialKontrah.setKontrah(kontrah);
            oddzialKontrah.setNazwa(Res.defaultDepartmentName);
            oddzialKontrah.setOddzialGlowny(bl2 ? 1 : 0);
            this.beginTransaction();
            this.getSession().saveOrUpdate((Object)oddzialKontrah);
            this.commitTransaction();
            return oddzialKontrah;
        }
        catch (HibernateException hibernateException) {
            String string2 = MessageFormat.format(Res.creatingDepartmentFailed, hibernateException.getMessage());
            log.error((Object)string2, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string2, (Throwable)hibernateException);
        }
    }

    static {
        ResourceManager.bind(OddzialKontrahDAO.class);
    }

    @ResourceContainer
    private static class Res {
        private static String creatingDepartment;
        private static String creatingDepartmentFailed;
        private static String defaultDepartmentName;

        private Res() {
        }
    }
}

