/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.pcbiznes.hibernate.database.dao;

import java.text.MessageFormat;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Property;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.lib.hibernate.dao.HibernateDAO;
import pl.com.stream.lib.hibernate.exception.DAOException;
import pl.com.stream.pcbiznes.hibernate.database.mappings.Kontrah;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KontrahDAO
extends HibernateDAO<Kontrah> {
    private static Logger log = Logger.getLogger(KontrahDAO.class);
    private static final long serialVersionUID = 7893612318099446798L;

    public List<Kontrah> getList(String string) throws DAOException {
        if (string == null) {
            return null;
        }
        List list = null;
        try {
            string = string.replaceAll("-", "");
            log.debug((Object)MessageFormat.format(Res.gettingThirdParty, string));
            this.beginTransaction();
            this.getSession().enableFilter("nipKontrahESklep").setParameter("nipKontrah", (Object)string);
            list = this.getSession().createCriteria(Kontrah.class).createAlias("daneKontrah", "dane").addOrder(Order.asc((String)"nazwa")).list();
            this.commitTransaction();
            return list;
        }
        catch (HibernateException hibernateException) {
            String string2 = MessageFormat.format(Res.gettingThirdPartyFailed, hibernateException.getMessage());
            log.error((Object)string2, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string2, (Throwable)hibernateException);
        }
    }

    public List<Kontrah> getList(String string, String string2, String string3, String string4) throws DAOException {
        try {
            string = string.replaceAll("-", "");
            log.debug((Object)MessageFormat.format(Res.gettingThirdParty, string));
            this.beginTransaction();
            this.getSession().enableFilter("oddzialGlownyKontrahESklep");
            this.getSession().enableFilter("nipKontrahESklep").setParameter("nipKontrah", (Object)string);
            Criteria criteria = this.getSession().createCriteria(Kontrah.class);
            criteria.createAlias("daneKontrah", "dane");
            if (string2 != null && string2.length() > 0) {
                criteria.add((Criterion)Property.forName((String)"dane.miejscowosc").like((Object)string2).ignoreCase());
            }
            if (string3 != null && string3.length() > 0) {
                criteria.add((Criterion)Property.forName((String)"dane.ulica").like((Object)string3).ignoreCase());
            }
            if (string4 != null && string4.length() > 0) {
                criteria.add((Criterion)Property.forName((String)"dane.nrDomu").eq((Object)string4));
            }
            List list = criteria.list();
            this.commitTransaction();
            return list;
        }
        catch (HibernateException hibernateException) {
            String string5 = MessageFormat.format(Res.gettingThirdPartyFailed, hibernateException.getMessage());
            log.error((Object)string5, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string5, (Throwable)hibernateException);
        }
    }

    public List<Kontrah> getList(String string, String string2, String string3, String string4, Integer[] integerArray, String string5) throws DAOException {
        try {
            string = string.replaceAll("-", "");
            log.debug((Object)MessageFormat.format(Res.gettingThirdParty, string));
            this.beginTransaction();
            this.getSession().enableFilter("oddzialGlownyKontrahESklep");
            if (integerArray != null && integerArray.length > 0) {
                this.getSession().enableFilter("grupyKontrahESklep").setParameterList("idRodzGrupKtr", (Object[])integerArray);
            }
            if (string5 != null && string5.length() > 0) {
                this.getSession().enableFilter("kodGrupaKtr").setParameter("kod", (Object)(string5 + "%"));
            }
            this.getSession().enableFilter("nipKontrahESklep").setParameter("nipKontrah", (Object)string);
            Criteria criteria = this.getSession().createCriteria(Kontrah.class);
            criteria.createAlias("daneKontrah", "dane");
            criteria.createAlias("grupyKontrah", "gr");
            if (string2 != null && string2.length() > 0) {
                criteria.add((Criterion)Property.forName((String)"dane.miejscowosc").like((Object)string2).ignoreCase());
            }
            if (string3 != null && string3.length() > 0) {
                criteria.add((Criterion)Property.forName((String)"dane.ulica").like((Object)string3).ignoreCase());
            }
            if (string4 != null && string4.length() > 0) {
                criteria.add((Criterion)Property.forName((String)"dane.nrDomu").eq((Object)string4));
            }
            this.commitTransaction();
            List list = criteria.list();
            switch (list.size()) {
                case 0: {
                    log.debug((Object)MessageFormat.format(Res.thirdPartyNotFound, string));
                    throw new DAOException(Res.informationTitle, Res.thirdPartyNotFoundOrHasNoRights);
                }
                case 1: {
                    Kontrah kontrah = (Kontrah)list.get(0);
                    log.debug((Object)MessageFormat.format(Res.foundOneThirdParty, kontrah.getId()));
                    break;
                }
                default: {
                    log.debug((Object)MessageFormat.format(Res.foundManyThirdParties, list.size(), string));
                }
            }
            return list;
        }
        catch (HibernateException hibernateException) {
            String string6 = MessageFormat.format(Res.gettingThirdPartyFailed, hibernateException.getMessage());
            log.error((Object)string6, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string6, (Throwable)hibernateException);
        }
    }

    static {
        ResourceManager.bind(KontrahDAO.class);
    }

    @ResourceContainer
    private static class Res {
        private static String foundManyThirdParties;
        private static String foundOneThirdParty;
        private static String gettingThirdParty;
        private static String gettingThirdPartyFailed;
        private static String informationTitle;
        private static String thirdPartyNotFound;
        private static String thirdPartyNotFoundOrHasNoRights;

        private Res() {
        }
    }
}

