/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.pcbiznes.hibernate.database.dao;

import java.io.Serializable;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Property;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.lib.hibernate.dao.HibernateDAO;
import pl.com.stream.lib.hibernate.exception.DAOException;
import pl.com.stream.pcbiznes.hibernate.database.mappings.Kartoteka;
import pl.com.stream.pcbiznes.hibernate.database.mappings.WystGrKart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KartotekaDAO
extends HibernateDAO<Kartoteka> {
    private static Logger log = Logger.getLogger(KartotekaDAO.class);
    private static final long serialVersionUID = 4121845105607139699L;

    public Kartoteka get(Integer n, Integer n2, Integer n3, Integer n4) throws DAOException {
        try {
            log.debug((Object)MessageFormat.format(Res.gettingArticle, n));
            this.beginTransaction();
            if (n2 != null && n2 != -1) {
                this.getSession().enableFilter("opisESklep").setParameter("idTypOpisKart", (Object)n2);
            }
            this.getSession().enableFilter("cenaESklep").setParameter("idDefCeny", (Object)n3);
            if (n4 != null) {
                this.getSession().enableFilter("stanNaMagazynieESklep").setParameter("idMagazyn", (Object)n4);
            }
            Kartoteka kartoteka = (Kartoteka)this.getSession().get(Kartoteka.class, (Serializable)n);
            this.commitTransaction();
            return kartoteka;
        }
        catch (HibernateException hibernateException) {
            String string = MessageFormat.format(Res.gettingArticleFailed, hibernateException.getMessage());
            log.error((Object)string, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string, (Throwable)hibernateException);
        }
    }

    public List<Kartoteka> getList(Integer n, Integer n2, Integer n3, final Integer n4, Integer n5, Integer n6, boolean bl) throws DAOException {
        try {
            log.debug((Object)MessageFormat.format(Res.gettingArticleList, n, n2));
            this.beginTransaction();
            if (n3 != null && n3 != -1) {
                this.getSession().enableFilter("opisESklep").setParameter("idTypOpisKart", (Object)n3);
            }
            if (n4 != null && n4 != -1) {
                this.getSession().enableFilter("nazwaESklep").setParameter("idTypNazwaKart", (Object)n4);
            }
            if (n6 != null) {
                this.getSession().enableFilter("stanNaMagazynieESklep").setParameter("idMagazyn", (Object)n6);
            }
            this.getSession().enableFilter("cenaESklep").setParameter("idDefCeny", (Object)n5);
            this.getSession().enableFilter("defWystOpak");
            Criteria criteria = this.getSession().createCriteria(WystGrKart.class).createAlias("kartoteka", "k").add((Criterion)Property.forName((String)"idRodzGrupKart").eq((Object)n)).add((Criterion)Property.forName((String)"idGrupaKart").eq((Object)n2));
            if (bl) {
                criteria.add((Criterion)Property.forName((String)"k.aktywny").eq((Object)1));
            }
            criteria.addOrder(Order.asc((String)"k.nazwaDl"));
            List list = criteria.list();
            this.commitTransaction();
            ArrayList<Kartoteka> arrayList = new ArrayList<Kartoteka>();
            for (WystGrKart wystGrKart : list) {
                arrayList.add(wystGrKart.getKartoteka());
            }
            if (n4 != null && n4 != -1) {
                Collections.sort(arrayList, new Comparator<Kartoteka>(){

                    @Override
                    public int compare(Kartoteka kartoteka, Kartoteka kartoteka2) {
                        String string = kartoteka.getNazwaDlaTypu(n4);
                        String string2 = kartoteka2.getNazwaDlaTypu(n4);
                        if (string == null) {
                            if (string2 != null) {
                                return -1;
                            }
                        } else if (!string.equals(string2)) {
                            Collator collator = Collator.getInstance();
                            return collator.compare(string, string2);
                        }
                        return 0;
                    }
                });
            }
            return arrayList;
        }
        catch (HibernateException hibernateException) {
            String string = MessageFormat.format(Res.gettingArticleListFailed, hibernateException.getMessage());
            log.error((Object)string, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string, (Throwable)hibernateException);
        }
    }

    static {
        ResourceManager.bind(KartotekaDAO.class);
    }

    @ResourceContainer
    private static class Res {
        private static String gettingArticle;
        private static String gettingArticleFailed;
        private static String gettingArticleList;
        private static String gettingArticleListFailed;

        private Res() {
        }
    }
}

