/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.pcbiznes.hibernate.database.dao;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.criterion.Order;
import org.hibernate.exception.GenericJDBCException;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.lib.hibernate.dao.HibernateDAO;
import pl.com.stream.lib.hibernate.exception.DAOException;
import pl.com.stream.pcbiznes.hibernate.database.mappings.GrupaOsobaKtr;
import pl.com.stream.pcbiznes.hibernate.database.mappings.WystGrupaOsKtr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrupaOsobaKtrDAO
extends HibernateDAO<GrupaOsobaKtr> {
    private static Logger log = Logger.getLogger(GrupaOsobaKtrDAO.class);
    private static Map<String, String> messagesMap = new HashMap<String, String>();
    private static final long serialVersionUID = -7608829664882934832L;

    public GrupaOsobaKtr create(GrupaOsobaKtr grupaOsobaKtr, Collection<Integer> collection) throws DAOException {
        try {
            log.debug((Object)MessageFormat.format(Res.creatingGroup, grupaOsobaKtr.getNazwaGrupy()));
            this.beginTransaction();
            grupaOsobaKtr = (GrupaOsobaKtr)this.getSession().merge((Object)grupaOsobaKtr);
            for (Integer n : collection) {
                WystGrupaOsKtr wystGrupaOsKtr = new WystGrupaOsKtr(grupaOsobaKtr.getId(), n);
                this.getSession().saveOrUpdate((Object)wystGrupaOsKtr);
            }
            this.commitTransaction();
            return grupaOsobaKtr;
        }
        catch (HibernateException hibernateException) {
            Object object;
            this.rollbackTransaction();
            if (hibernateException instanceof GenericJDBCException && (object = (GenericJDBCException)hibernateException).getErrorCode() == 335544349) {
                throw new DAOException(Res.informationTitle, Res.groupExist);
            }
            object = MessageFormat.format(Res.creatingGroupFailed, hibernateException.getMessage());
            log.error(object, (Throwable)hibernateException);
            throw new DAOException((String)object, (Throwable)hibernateException);
        }
    }

    public void delete(Integer n) throws DAOException {
        try {
            log.debug((Object)MessageFormat.format(Res.removingGroup, n));
            this.beginTransaction();
            GrupaOsobaKtr grupaOsobaKtr = (GrupaOsobaKtr)this.getSession().get(GrupaOsobaKtr.class, (Serializable)n);
            if (grupaOsobaKtr != null) {
                this.getSession().delete((Object)grupaOsobaKtr);
            }
            this.commitTransaction();
        }
        catch (HibernateException hibernateException) {
            Object object;
            this.rollbackTransaction();
            if (hibernateException instanceof GenericJDBCException && (object = (GenericJDBCException)hibernateException).getErrorCode() == 335544466) {
                String string = Res.informationTitle;
                String string2 = null;
                if (object.getCause() != null) {
                    string2 = messagesMap.get(object.getCause().getMessage());
                }
                if (string2 == null) {
                    string2 = Res.removingGroupFailedConstraintViolation;
                }
                throw new DAOException(string, string2);
            }
            object = MessageFormat.format(Res.removingGroupFailed, hibernateException.getMessage());
            log.error(object, (Throwable)hibernateException);
            throw new DAOException((String)object, (Throwable)hibernateException);
        }
    }

    public List<GrupaOsobaKtr> getList() throws DAOException {
        try {
            log.debug((Object)Res.gettingGroupList);
            this.beginTransaction();
            List list = this.getSession().createCriteria(GrupaOsobaKtr.class).addOrder(Order.asc((String)"nazwaGrupy")).list();
            this.commitTransaction();
            return list;
        }
        catch (HibernateException hibernateException) {
            String string = MessageFormat.format(Res.gettingGroupListFailed, hibernateException.getMessage());
            log.error((Object)string, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string, (Throwable)hibernateException);
        }
    }

    public void update(GrupaOsobaKtr grupaOsobaKtr, Collection<Integer> collection) throws DAOException {
        try {
            log.debug((Object)MessageFormat.format(Res.updatingGroup, grupaOsobaKtr.getId()));
            this.beginTransaction();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            HashSet<Integer> hashSet = new HashSet<Integer>();
            Collection<WystGrupaOsKtr> collection2 = grupaOsobaKtr.getWystGrupaOsKtr();
            Iterator<Serializable> iterator = collection2.iterator();
            while (iterator.hasNext()) {
                WystGrupaOsKtr serializable = iterator.next();
                if (!collection.contains(serializable.getIdOsobaKontrah())) {
                    arrayList.add(serializable.getIdOsobaKontrah());
                    iterator.remove();
                    continue;
                }
                hashSet.add(serializable.getIdOsobaKontrah());
            }
            for (Integer n : collection) {
                if (hashSet.contains(n)) continue;
                collection2.add(new WystGrupaOsKtr(grupaOsobaKtr.getId(), n));
            }
            if (arrayList.size() > 0) {
                iterator = this.getSession().createSQLQuery("DELETE FROM WYSTGRUPAOSKTR wystGr WHERE wystGr.ID_GRUPAOSOBAKTR = :idGrupa AND wystGr.ID_OSOBAKONTRAH IN (:idOsobaList)");
                iterator.setParameter("idGrupa", grupaOsobaKtr.getId());
                iterator.setParameterList("idOsobaList", arrayList);
                iterator.executeUpdate();
            }
            this.getSession().update((Object)grupaOsobaKtr);
            this.commitTransaction();
        }
        catch (HibernateException hibernateException) {
            Object object;
            this.rollbackTransaction();
            if (hibernateException instanceof GenericJDBCException && (object = (GenericJDBCException)hibernateException).getErrorCode() == 335544349) {
                throw new DAOException(Res.informationTitle, Res.groupExist);
            }
            object = MessageFormat.format(Res.updatingGroupFailed, hibernateException.getMessage());
            log.error(object, (Throwable)hibernateException);
            throw new DAOException((String)object, (Throwable)hibernateException);
        }
    }

    static {
        ResourceManager.bind(GrupaOsobaKtrDAO.class);
        messagesMap.put("GDS Exception. 335544466. violation of FOREIGN KEY constraint \"FK_SKL_KONFGRUPAOSKTR_GROSKTR\" on table \"SKL_KONFGRUPAOSKTR\"\nForeign key references are present for the record", Res.removingGroupFailedConfigurationExists);
        messagesMap.put("GDS Exception. 335544466. violation of FOREIGN KEY constraint \"FK_WYSTGRUPAOSKTR_GRUPAOSKTR\" on table \"WYSTGRUPAOSKTR\"\nForeign key references are present for the record", Res.removingGroupFailedUsersExists);
    }

    @ResourceContainer
    private static class Res {
        private static String creatingGroup;
        private static String creatingGroupFailed;
        private static String gettingGroupList;
        private static String gettingGroupListFailed;
        private static String groupExist;
        private static String informationTitle;
        private static String removingGroup;
        private static String removingGroupFailed;
        private static String removingGroupFailedConfigurationExists;
        private static String removingGroupFailedConstraintViolation;
        private static String removingGroupFailedUsersExists;
        private static String updatingGroup;
        private static String updatingGroupFailed;

        private Res() {
        }
    }
}

