/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.pcbiznes.hibernate.database.dao;

import java.text.MessageFormat;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Property;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.lib.hibernate.dao.HibernateDAO;
import pl.com.stream.lib.hibernate.exception.DAOException;
import pl.com.stream.pcbiznes.hibernate.database.mappings.EmailOsobaKtr;
import pl.com.stream.pcbiznes.hibernate.database.mappings.OsobaKontrah;
import pl.com.stream.pcbiznes.hibernate.database.mappings.TypeMail;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailOsobaKtrDAO
extends HibernateDAO<EmailOsobaKtr> {
    private static Logger log = Logger.getLogger(EmailOsobaKtrDAO.class);
    private static final long serialVersionUID = 4456355762588661840L;

    public EmailOsobaKtr create(String string, TypeMail typeMail, OsobaKontrah osobaKontrah) throws DAOException {
        try {
            EmailOsobaKtr emailOsobaKtr = new EmailOsobaKtr();
            emailOsobaKtr.setEmail(string);
            emailOsobaKtr.setTypeMail(typeMail);
            emailOsobaKtr.setOsobaKontrah(osobaKontrah);
            log.debug((Object)MessageFormat.format(Res.creatingNewEmail, string));
            this.beginTransaction();
            this.getSession().saveOrUpdate((Object)emailOsobaKtr);
            this.commitTransaction();
            log.debug((Object)MessageFormat.format(Res.newEmailCreated, emailOsobaKtr.getId()));
            return emailOsobaKtr;
        }
        catch (HibernateException hibernateException) {
            String string2 = MessageFormat.format(Res.creatingNewEmailFailed, string);
            log.error((Object)string2, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string2, (Throwable)hibernateException);
        }
    }

    public EmailOsobaKtr get(TypeMail typeMail, OsobaKontrah osobaKontrah) throws DAOException {
        String string = osobaKontrah.getImie() + " " + osobaKontrah.getNazwisko();
        try {
            EmailOsobaKtr emailOsobaKtr = null;
            log.debug((Object)MessageFormat.format(Res.gettingEmail, typeMail.getNazwaTypu(), string));
            this.beginTransaction();
            List list = this.getSession().createCriteria(EmailOsobaKtr.class).add((Criterion)Property.forName((String)"typeMail").eq((Object)typeMail)).add((Criterion)Property.forName((String)"osobaKontrah").eq((Object)osobaKontrah)).list();
            this.commitTransaction();
            switch (list.size()) {
                case 1: {
                    emailOsobaKtr = (EmailOsobaKtr)list.get(0);
                    break;
                }
                default: {
                    if (list.size() <= 1) break;
                    emailOsobaKtr = (EmailOsobaKtr)list.get(0);
                    String string2 = MessageFormat.format(Res.foundManyEmails, string, typeMail.getNazwaTypu(), list.size(), emailOsobaKtr.getEmail());
                    log.debug((Object)string2);
                }
            }
            return emailOsobaKtr;
        }
        catch (HibernateException hibernateException) {
            String string3 = MessageFormat.format(Res.gettingEmailFailed, string, hibernateException.getMessage());
            log.error((Object)string3, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string3, (Throwable)hibernateException);
        }
    }

    static {
        ResourceManager.bind(EmailOsobaKtrDAO.class);
    }

    @ResourceContainer
    private static class Res {
        private static String creatingNewEmail;
        private static String creatingNewEmailFailed;
        private static String foundManyEmails;
        private static String gettingEmail;
        private static String gettingEmailFailed;
        private static String newEmailCreated;

        private Res() {
        }
    }
}

