/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.pcbiznes.hibernate.database.dao;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.lib.hibernate.dao.HibernateDAO;
import pl.com.stream.lib.hibernate.exception.DAOException;
import pl.com.stream.pcbiznes.hibernate.database.mappings.DodDokumZew;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DodDokumZewDAO
extends HibernateDAO<DodDokumZew> {
    private static Logger log = Logger.getLogger(DodDokumZewDAO.class);
    private static final long serialVersionUID = 8953398248440472725L;

    public DodDokumZewDAO(String string) {
        this.setCurrentConnectionName(string);
    }

    public DodDokumZew create(File file) throws DAOException {
        if (!file.isFile()) {
            return null;
        }
        String string = file.getName();
        DodDokumZew dodDokumZew = new DodDokumZew();
        dodDokumZew.setCompression(0);
        dodDokumZew.setNazwaPliku(string);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            dodDokumZew.setDocumentContent(fileInputStream);
            log.debug((Object)MessageFormat.format(Res.addingAttachment, file.getAbsolutePath()));
            this.beginTransaction();
            this.getSession(this.getCurrentConnectionName()).save((Object)dodDokumZew);
            this.commitTransaction();
            DodDokumZew dodDokumZew2 = dodDokumZew;
            return dodDokumZew2;
        }
        catch (IOException iOException) {
            log.error((Object)iOException);
            this.rollbackTransaction();
        }
        catch (HibernateException hibernateException) {
            String string2 = MessageFormat.format(Res.addingAttachmentFailed, hibernateException.getMessage());
            log.error((Object)string2, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string2, (Throwable)hibernateException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public void delete(Integer n) throws DAOException {
        if (n == null) {
            return;
        }
        try {
            log.debug((Object)MessageFormat.format(Res.removingAttachment, n));
            this.beginTransaction();
            SQLQuery sQLQuery = this.getSession().createSQLQuery("DELETE FROM DODDOKUMZEW dok WHERE dok.ID_DODDOKUMZEW = :id");
            sQLQuery.setInteger("id", n.intValue());
            sQLQuery.executeUpdate();
            this.commitTransaction();
        }
        catch (HibernateException hibernateException) {
            String string = MessageFormat.format(Res.removingAttachmentFailed, hibernateException.getMessage());
            log.error((Object)string, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string, (Throwable)hibernateException);
        }
    }

    static {
        ResourceManager.bind(DodDokumZewDAO.class);
    }

    @ResourceContainer
    private static class Res {
        private static String addingAttachment;
        private static String addingAttachmentFailed;
        private static String removingAttachment;
        private static String removingAttachmentFailed;

        private Res() {
        }
    }
}

