/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.pcbiznes.hibernate.database.dao;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.lib.hibernate.dao.HibernateSessionProvider;
import pl.com.stream.lib.hibernate.exception.DAOException;
import pl.com.stream.pcbiznes.hibernate.database.mappings.DodDokumZew;
import pl.com.stream.pcbiznes.hibernate.database.mappings.DodDokumZewBazaFirmowa;
import pl.com.stream.pcbiznes.hibernate.database.mappings.ZdarzenieCrm;
import pl.com.stream.pcbiznes.hibernate.database.mappings.ZdarzenieCrmDokZew;
import pl.com.stream.pcbiznes.hibernate.database.mappings.ZdarzenieCrmDokument;

public class DodDokumZdarzenieCrmDAO
extends HibernateSessionProvider {
    private static Logger log = Logger.getLogger(DodDokumZdarzenieCrmDAO.class);
    private static final long serialVersionUID = -8953587956270505830L;
    private final String SQL_CALL_ZDARZENIE_CRM_ADD = "{call ZDARZENIE_CRM_ADD(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)}";

    public Integer addZalacznik(ZdarzenieCrm zdarzenieCrm, Integer n, DodDokumZew dodDokumZew, String string) throws DAOException {
        try {
            Object object;
            log.debug((Object)MessageFormat.format(Res.addingAttachment, zdarzenieCrm.getId()));
            this.beginTransaction();
            DodDokumZewBazaFirmowa dodDokumZewBazaFirmowa = new DodDokumZewBazaFirmowa(dodDokumZew);
            this.getSession().save((Object)dodDokumZewBazaFirmowa);
            Integer n2 = this.createZdarzenieCrm(n, dodDokumZewBazaFirmowa.getNazwaPliku(), string, zdarzenieCrm);
            if (string != null && string.length() > 500 && (object = (ZdarzenieCrmDokument)this.getSession().get(ZdarzenieCrmDokument.class, (Serializable)n2)) != null) {
                ((ZdarzenieCrmDokument)object).setOpis(string);
                this.getSession().save(object);
            }
            object = dodDokumZewBazaFirmowa.getId();
            ZdarzenieCrmDokZew.Id id = new ZdarzenieCrmDokZew.Id(n2, (Integer)object);
            ZdarzenieCrmDokZew zdarzenieCrmDokZew = new ZdarzenieCrmDokZew(id);
            this.getSession().save((Object)zdarzenieCrmDokZew);
            this.commitTransaction();
            return n2;
        }
        catch (DAOException dAOException) {
            this.rollbackTransaction();
            throw dAOException;
        }
        catch (HibernateException hibernateException) {
            this.rollbackTransaction();
            String string2 = MessageFormat.format(Res.addingAttachmentFailed, hibernateException.getMessage());
            log.error((Object)string2, (Throwable)hibernateException);
            throw new DAOException(string2, (Throwable)hibernateException);
        }
        catch (SQLException sQLException) {
            this.rollbackTransaction();
            String string3 = MessageFormat.format(Res.addingAttachmentFailed, sQLException.getMessage());
            log.error((Object)string3, (Throwable)sQLException);
            throw new DAOException(string3, (Throwable)sQLException);
        }
    }

    public void deleteZalacznik(Integer n, Integer n2) throws DAOException {
        if (n == null) {
            return;
        }
        try {
            SQLQuery sQLQuery;
            log.debug((Object)MessageFormat.format(Res.removingAttachment, n));
            this.beginTransaction();
            List list = this.getSession().createSQLQuery("SELECT crm.ID_ZDARZENIECRM FROM ZDARZENIECRM crm WHERE crm.ID_ZDARZENIECRM_NAD = " + n).list();
            if (list.size() > 0) {
                throw new DAOException(Res.informationTitle, Res.removingAttachmentFailedByDependency);
            }
            if (n2 != null) {
                sQLQuery = this.getSession().createSQLQuery("DELETE FROM ZDARZENIECRM_DOKZEW crmDokZew WHERE crmDokZew.ID_ZDARZENIECRM = :idCrm AND crmDokZew.ID_DODDOKUMZEW = :idDok");
                sQLQuery.setInteger("idCrm", n.intValue());
                sQLQuery.setInteger("idDok", n2.intValue());
                sQLQuery.executeUpdate();
                SQLQuery sQLQuery2 = this.getSession().createSQLQuery("DELETE FROM DODDOKUMZEW dok WHERE dok.ID_DODDOKUMZEW = :id");
                sQLQuery2.setInteger("id", n2.intValue());
                sQLQuery2.executeUpdate();
            }
            sQLQuery = this.getSession().createSQLQuery("DELETE FROM ZDARZENIECRM crm WHERE crm.ID_ZDARZENIECRM = :id");
            sQLQuery.setInteger("id", n.intValue());
            sQLQuery.executeUpdate();
            this.commitTransaction();
        }
        catch (HibernateException hibernateException) {
            Object object;
            this.rollbackTransaction();
            if (hibernateException.getCause() instanceof SQLException && ((SQLException)(object = (SQLException)hibernateException.getCause())).getErrorCode() == 335544466) {
                throw new DAOException(Res.informationTitle, Res.removingAttachmentFailedByDependency);
            }
            object = MessageFormat.format(Res.removingAttachmentFailed, hibernateException.getMessage());
            log.error(object, (Throwable)hibernateException);
            throw new DAOException(Res.informationTitle, (String)object);
        }
    }

    private Integer createZdarzenieCrm(Integer n, String string, String string2, ZdarzenieCrm zdarzenieCrm) throws HibernateException, DAOException, SQLException {
        log.debug((Object)Res.creatingNewCrmEvent);
        Connection connection = this.getSession().connection();
        CallableStatement callableStatement = connection.prepareCall("{call ZDARZENIE_CRM_ADD(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)}");
        callableStatement.setInt(1, (int)n);
        callableStatement.setString(2, string);
        if (string2 != null && string2.length() <= 500) {
            callableStatement.setString(3, string2);
        } else {
            callableStatement.setNull(3, 2004);
        }
        callableStatement.setInt(4, 2);
        callableStatement.setInt(5, (int)zdarzenieCrm.getUzytkownikWyk().getId());
        callableStatement.setInt(6, (int)zdarzenieCrm.getId());
        if (zdarzenieCrm.getKontrah() != null) {
            callableStatement.setInt(7, (int)zdarzenieCrm.getKontrah().getId());
        } else {
            callableStatement.setNull(7, 4);
        }
        callableStatement.setNull(8, 4);
        callableStatement.setNull(9, 4);
        callableStatement.setNull(10, 93);
        callableStatement.setNull(11, 93);
        callableStatement.setNull(12, 93);
        callableStatement.setNull(13, 93);
        callableStatement.setInt(14, 1);
        callableStatement.setInt(15, (int)zdarzenieCrm.getPrawaOsZNad());
        callableStatement.setInt(16, (int)zdarzenieCrm.getPrawaAll());
        callableStatement.setNull(17, 93);
        callableStatement.setNull(18, 93);
        callableStatement.setInt(19, 100);
        callableStatement.setNull(20, 93);
        ResultSet resultSet = callableStatement.executeQuery();
        int n2 = -1;
        int n3 = 9;
        if (resultSet.next()) {
            n2 = resultSet.getInt(1);
            n3 = resultSet.getInt(2);
        }
        resultSet.close();
        callableStatement.close();
        if (n3 == 0) {
            log.debug((Object)MessageFormat.format(Res.newCrmEventCreated, n2));
            return n2;
        }
        String string3 = null;
        switch (n3) {
            case 1: {
                string3 = Res.newCrmEventCreationFailedError1;
                break;
            }
            case 2: {
                string3 = Res.newCrmEventCreationFailedError2;
                break;
            }
            case 3: {
                string3 = Res.newCrmEventCreationFailedError3;
                break;
            }
            default: {
                string3 = MessageFormat.format(Res.newCrmEventCreationFailedError, n3);
            }
        }
        log.debug((Object)string3);
        throw new DAOException(Res.informationTitle, string3);
    }

    static {
        ResourceManager.bind(DodDokumZdarzenieCrmDAO.class);
    }

    @ResourceContainer
    private static class Res {
        private static String addingAttachment;
        private static String addingAttachmentFailed;
        private static String creatingNewCrmEvent;
        private static String informationTitle;
        private static String newCrmEventCreated;
        private static String newCrmEventCreationFailedError;
        private static String newCrmEventCreationFailedError1;
        private static String newCrmEventCreationFailedError2;
        private static String newCrmEventCreationFailedError3;
        private static String removingAttachment;
        private static String removingAttachmentFailed;
        private static String removingAttachmentFailedByDependency;

        private Res() {
        }
    }
}

