/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.pool;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.pool.PoolDebugConfiguration;
import org.firebirdsql.pool.PooledConnectionEventListener;
import org.firebirdsql.pool.PooledConnectionHandler;
import org.firebirdsql.pool.PooledObject;
import org.firebirdsql.pool.PooledPreparedStatementHandler;
import org.firebirdsql.pool.XCachablePreparedStatement;
import org.firebirdsql.pool.XConnectionManager;
import org.firebirdsql.pool.XPingableConnection;
import org.firebirdsql.pool.XPreparedStatementCache;
import org.firebirdsql.pool.XStatementManager;

public class PingablePooledConnection
implements PooledConnection,
PooledObject,
XConnectionManager,
XPingableConnection,
XStatementManager {
    private static final boolean LOG_PREPARE_STATEMENT = PoolDebugConfiguration.DEBUG_STMT_POOL;
    private static final boolean LOG_POOL_CLEANING = PoolDebugConfiguration.DEBUG_STMT_POOL;
    private static final boolean LOG_META_DATA = PoolDebugConfiguration.LOG_DEBUG_INFO;
    private static Logger log = LoggerFactory.getLogger(PingablePooledConnection.class, false);
    protected Connection jdbcConnection;
    private HashSet eventListeners = new HashSet();
    private boolean invalid;
    private PooledConnectionHandler currentConnection;
    private String pingStatement;
    private long lastPingTime = System.currentTimeMillis();
    private int pingInterval = 0;
    private int maxStatements;
    private boolean keepStatements;
    private boolean supportsStatementsAccrossCommit;
    private boolean supportsStatementsAccrossRollback;
    private boolean statementPooling;
    private int transactionIsolation = -1;
    private HashMap statements = new HashMap();

    protected Logger getLogChannel() {
        return log;
    }

    protected PingablePooledConnection(Connection connection, boolean statementPooling, int maxStatements, boolean keepStatements) throws SQLException {
        this.jdbcConnection = connection;
        this.statementPooling = statementPooling;
        this.maxStatements = maxStatements;
        this.keepStatements = keepStatements;
        this.supportsStatementsAccrossCommit = connection.getMetaData().supportsOpenStatementsAcrossCommit();
        if (LOG_META_DATA && this.getLogChannel() != null) {
            this.getLogChannel().info("Pool supports open statements across commit : " + this.supportsStatementsAccrossCommit);
        }
        this.supportsStatementsAccrossRollback = connection.getMetaData().supportsOpenStatementsAcrossRollback();
        if (LOG_META_DATA && this.getLogChannel() != null) {
            this.getLogChannel().info("Pool supports open statements across rollback : " + this.supportsStatementsAccrossRollback);
        }
    }

    protected PingablePooledConnection(Connection connection, String pingStatement, int pingInterval, boolean statementPooling, int maxStatements, boolean keepStatements) throws SQLException {
        this(connection, statementPooling, maxStatements, keepStatements);
        this.pingStatement = pingStatement;
        this.pingInterval = pingInterval;
    }

    public void setDefaultTransactionIsolation(int isolation) {
        this.transactionIsolation = isolation;
    }

    public long getLastPingTime() {
        return this.lastPingTime;
    }

    public boolean isStatementPooling() {
        return this.statementPooling;
    }

    public boolean isKeepStatements() {
        return this.keepStatements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean ping() {
        boolean bl;
        block7: {
            if (this.pingStatement == null) {
                return false;
            }
            Statement stmt = null;
            try {
                stmt = this.jdbcConnection.createStatement();
                ResultSet rs = stmt.executeQuery(this.pingStatement);
                bl = rs.next();
                if (stmt == null) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    this.lastPingTime = System.currentTimeMillis();
                    throw throwable;
                }
                catch (SQLException sqlex) {
                    return false;
                }
            }
            stmt.close();
        }
        this.lastPingTime = System.currentTimeMillis();
        return bl;
    }

    private void invalidate() {
        this.invalid = true;
    }

    private void checkValidity() {
        if (this.invalid) {
            throw new IllegalStateException("Cannot execute desired operation because pooled connection has invalid state.");
        }
    }

    public boolean isValid() {
        if (this.invalid) {
            return false;
        }
        if (this.pingInterval > 0 && System.currentTimeMillis() - this.lastPingTime > (long)this.pingInterval && this.pingStatement != null) {
            return this.ping();
        }
        return true;
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener listener) {
        this.eventListeners.add(listener);
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener listener) {
        this.eventListeners.remove(listener);
    }

    public void close() throws SQLException {
        this.internalClose();
        ConnectionEvent event = new ConnectionEvent(this);
        ArrayList tempListeners = new ArrayList(this.eventListeners);
        for (ConnectionEventListener listener : tempListeners) {
            if (!(listener instanceof PooledConnectionEventListener)) continue;
            PooledConnectionEventListener pooledEventListener = (PooledConnectionEventListener)listener;
            pooledEventListener.physicalConnectionClosed(event);
        }
    }

    protected void internalClose() throws SQLException {
        this.checkValidity();
        if (this.currentConnection != null) {
            this.currentConnection.deallocate();
        }
        this.jdbcConnection.close();
        this.statements.clear();
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deallocate() {
        try {
            this.internalClose();
        }
        catch (SQLException ex) {
            if (log != null) {
                log.warn("Could not cleanly deallocate connection.", ex);
            }
        }
        finally {
            ConnectionEvent event = new ConnectionEvent(this);
            ArrayList tempListeners = new ArrayList(this.eventListeners);
            for (ConnectionEventListener listener : tempListeners) {
                if (!(listener instanceof PooledConnectionEventListener)) continue;
                PooledConnectionEventListener pooledEventListener = (PooledConnectionEventListener)listener;
                pooledEventListener.physicalConnectionDeallocated(event);
            }
        }
    }

    public Connection getConnection() throws SQLException {
        this.checkValidity();
        if (this.currentConnection != null) {
            throw new IllegalStateException("Cannot provide new connection while old one is still in use.");
        }
        this.currentConnection = new PooledConnectionHandler(this.jdbcConnection, this);
        Connection result = this.currentConnection.getProxy();
        this.configureConnectionDefaults(result);
        return result;
    }

    protected void configureConnectionDefaults(Connection connection) throws SQLException {
        connection.setAutoCommit(true);
        connection.setReadOnly(false);
        if (this.transactionIsolation != -1) {
            connection.setTransactionIsolation(this.transactionIsolation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement getPreparedStatement(String statement, int resultSetType, int resultSetConcurrency) throws SQLException {
        XCachablePreparedStatement stmt;
        if (!this.isStatementPooling()) {
            return this.jdbcConnection.prepareStatement(statement, resultSetType, resultSetConcurrency);
        }
        HashMap hashMap = this.statements;
        synchronized (hashMap) {
            XPreparedStatementCache stmtCache = (XPreparedStatementCache)this.statements.get(statement);
            if (stmtCache == null) {
                stmtCache = new XPreparedStatementCache(this, statement, resultSetType, resultSetConcurrency, this.maxStatements);
                this.statements.put(statement, stmtCache);
            }
            stmt = stmtCache.take(this.currentConnection.getProxy());
        }
        return stmt;
    }

    public XCachablePreparedStatement prepareStatement(String statement, int resultSetType, int resultSetConcurrency, boolean cached) throws SQLException {
        if (LOG_PREPARE_STATEMENT && this.getLogChannel() != null) {
            this.getLogChannel().info("Prepared statement for SQL '" + statement + "'");
        }
        PreparedStatement stmt = this.jdbcConnection.prepareStatement(statement, resultSetType, resultSetConcurrency);
        Class[] implementedInterfaces = PooledConnectionHandler.getAllInterfaces(stmt.getClass());
        PooledPreparedStatementHandler handler = new PooledPreparedStatementHandler(statement, stmt, this, cached);
        Class[] interfacesToImplement = new Class[implementedInterfaces.length + 1];
        System.arraycopy(implementedInterfaces, 0, interfacesToImplement, 0, implementedInterfaces.length);
        interfacesToImplement[implementedInterfaces.length] = XCachablePreparedStatement.class;
        return (XCachablePreparedStatement)Proxy.newProxyInstance(this.getClass().getClassLoader(), interfacesToImplement, (InvocationHandler)handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanCache() throws SQLException {
        if (LOG_POOL_CLEANING && this.getLogChannel() != null) {
            this.getLogChannel().info("Prepared statement cache cleaned.");
        }
        HashMap hashMap = this.statements;
        synchronized (hashMap) {
            Iterator iter = this.statements.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry item = iter.next();
                XPreparedStatementCache stmtCache = (XPreparedStatementCache)item.getValue();
                iter.remove();
                stmtCache.invalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void statementClosed(String statement, Object proxy) throws SQLException {
        HashMap hashMap = this.statements;
        synchronized (hashMap) {
            XPreparedStatementCache stmtCache = (XPreparedStatementCache)this.statements.get(statement);
            if (stmtCache == null) {
                if (this.getLogChannel() != null) {
                    this.getLogChannel().error("Cannot find statement cache for SQL \"" + statement + "\". Trying to close statement to release resources.");
                }
                if (proxy instanceof XCachablePreparedStatement) {
                    ((XCachablePreparedStatement)proxy).forceClose();
                }
            } else {
                stmtCache.put(proxy);
            }
        }
    }

    public void connectionClosed(PooledConnectionHandler connection) throws SQLException {
        if (connection != this.currentConnection) {
            throw new IllegalArgumentException("Notified about a connection that is not under my control.");
        }
        if (!this.keepStatements) {
            this.cleanCache();
        }
        this.currentConnection = null;
        ConnectionEvent event = new ConnectionEvent(this);
        ArrayList tempListeners = new ArrayList(this.eventListeners);
        Iterator iter = tempListeners.iterator();
        while (iter.hasNext()) {
            ((ConnectionEventListener)iter.next()).connectionClosed(event);
        }
    }

    public void connectionErrorOccured(PooledConnectionHandler connection, SQLException ex) {
        ConnectionEvent event = new ConnectionEvent(this, ex);
        ArrayList tempListeners = new ArrayList(this.eventListeners);
        Iterator iter = tempListeners.iterator();
        while (iter.hasNext()) {
            ((ConnectionEventListener)iter.next()).connectionErrorOccurred(event);
        }
    }

    public boolean isValid(PooledConnectionHandler connection) {
        return connection == this.currentConnection;
    }

    public void connectionCommitted(PooledConnectionHandler connection) throws SQLException {
        if (connection != this.currentConnection) {
            throw new IllegalArgumentException("Specified connection does not correspond current physical connection");
        }
        if (!this.supportsStatementsAccrossCommit) {
            this.cleanCache();
        }
    }

    public void connectionRolledBack(PooledConnectionHandler connection) throws SQLException {
        if (connection != this.currentConnection) {
            throw new IllegalArgumentException("Specified connection does not correspond current physical connection");
        }
        if (!this.supportsStatementsAccrossRollback) {
            this.cleanCache();
        }
    }
}

