/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.management;

import java.sql.SQLException;
import org.firebirdsql.gds.ServiceRequestBuffer;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.management.FBServiceManager;
import org.firebirdsql.management.StatisticsManager;

public class FBStatisticsManager
extends FBServiceManager
implements StatisticsManager {
    public FBStatisticsManager() {
    }

    public FBStatisticsManager(String gdsType) {
        super(gdsType);
    }

    public FBStatisticsManager(GDSType gdsType) {
        super(gdsType);
    }

    public void getHeaderPage() throws SQLException {
        ServiceRequestBuffer srb = this.createStatsSRB(4);
        this.executeServicesOperation(srb);
    }

    public void getDatabaseStatistics() throws SQLException {
        ServiceRequestBuffer srb = this.createDefaultStatsSRB();
        this.executeServicesOperation(srb);
    }

    public void getDatabaseStatistics(int options) throws SQLException {
        int possible = 25;
        if (options != 0 && (options | 0x19) != 25) {
            throw new IllegalArgumentException("options must be 0 or a combination of DATA_TABLE_STATISTICS, SYSTEM_TABLE_STATISTICS, INDEX_STATISTICS, or 0");
        }
        if (options == 0) {
            options = 2;
        }
        ServiceRequestBuffer srb = this.createStatsSRB(options);
        this.executeServicesOperation(srb);
    }

    private ServiceRequestBuffer createDefaultStatsSRB() {
        return this.createStatsSRB(0);
    }

    private ServiceRequestBuffer createStatsSRB(int options) {
        return this.createRequestBuffer(11, options);
    }
}

