/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.sql.DataTruncation;
import java.sql.SQLException;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.jdbc.FBConnectionHelper;
import org.firebirdsql.jdbc.field.FBStringField;
import org.firebirdsql.jdbc.field.FieldDataProvider;

public class FBWorkaroundStringField
extends FBStringField {
    private int possibleCharLength;
    private int bytesPerCharacter = 1;
    private boolean trimString;
    private static final String[] SYSTEM_TABLES = new String[]{"RDB$CHARACTER_SETS", "RDB$CHECK_CONSTRAINTS", "RDB$COLLATIONS", "RDB$DATABASE", "RDB$DEPENDENCIES", "RDB$EXCEPTIONS", "RDB$FIELDS", "RDB$FIELD_DIMENSIONS", "RDB$FILES", "RDB$FILTERS", "RDB$FORMATS", "RDB$FUNCTIONS", "RDB$FUNCTION_ARGUMENTS", "RDB$GENERATORS", "RDB$INDEX_SEGMENTS", "RDB$INDICES", "RDB$LOG_FILES", "RDB$PAGES", "RDB$PROCEDURES", "RDB$PROCEDURE_PARAMETERS", "RDB$REF_CONSTRAINTS", "RDB$RELATIONS", "RDB$RELATION_CONSTRAINTS", "RDB$RELATION_FIELDS", "RDB$ROLES", "RDB$SECURITY_CLASSES", "RDB$TRANSACTIONS", "RDB$TRIGGERS", "RDB$TRIGGER_MESSAGES", "RDB$TYPES", "RDB$USER_PRIVILEGES", "RDB$VIEW_RELATIONS"};

    public FBWorkaroundStringField(XSQLVAR field, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(field, dataProvider, requiredType);
        this.possibleCharLength = field.sqllen / this.bytesPerCharacter;
    }

    public void setConnection(GDSHelper gdsHelper) {
        super.setConnection(gdsHelper);
        this.bytesPerCharacter = FBConnectionHelper.getIscEncodingSize(this.iscEncoding);
        this.possibleCharLength = this.field.sqllen / this.bytesPerCharacter;
    }

    public void setTrimString(boolean trimString) {
        this.trimString = trimString;
    }

    public void setString(String value) throws SQLException {
        this.setStringForced(value);
        if (value == STRING_NULL_VALUE) {
            return;
        }
        if (this.getFieldData().length > this.field.sqllen && !this.isSystemTable(this.field.relname)) {
            throw new DataTruncation(-1, true, false, this.getFieldData().length, this.field.sqllen);
        }
    }

    public void setStringForced(String value) throws SQLException {
        if (value == STRING_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setFieldData(this.field.encodeString(value, this.javaEncoding, this.mappingPath));
    }

    public String getString() throws SQLException {
        String result = super.getString();
        if (result == STRING_NULL_VALUE) {
            return STRING_NULL_VALUE;
        }
        if (FBWorkaroundStringField.isType(this.field, 12)) {
            return result;
        }
        if (this.field.sqllen % this.bytesPerCharacter == 0 && result.length() > this.possibleCharLength) {
            result = result.substring(0, this.possibleCharLength);
        }
        if (this.trimString) {
            result = result.trim();
        }
        return result;
    }

    private boolean isSystemTable(String tableName) {
        boolean result = false;
        for (int i = 0; i < SYSTEM_TABLES.length; ++i) {
            if (!SYSTEM_TABLES[i].equals(tableName)) continue;
            result = true;
            break;
        }
        return result;
    }
}

