/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.SQLException;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.FBBlob;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.field.FBFlushableField;
import org.firebirdsql.jdbc.field.FBStringField;
import org.firebirdsql.jdbc.field.FieldDataProvider;

public class FBLongVarCharField
extends FBStringField
implements FBFlushableField {
    private static final int BUFF_SIZE = 4096;
    private FBBlob blob;
    private int length;
    private byte[] bytes;
    private InputStream binaryStream;
    private Reader characterStream;

    FBLongVarCharField(XSQLVAR field, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(field, dataProvider, requiredType);
    }

    public void close() throws SQLException {
        try {
            if (this.blob != null) {
                this.blob.close();
            }
        }
        catch (IOException ioex) {
            throw new FBSQLException(ioex);
        }
        finally {
            this.blob = null;
            this.bytes = null;
            this.binaryStream = null;
            this.characterStream = null;
            this.length = 0;
        }
    }

    public Blob getBlob() throws SQLException {
        if (this.blob != null) {
            return this.blob;
        }
        if (this.getFieldData() == null) {
            return BLOB_NULL_VALUE;
        }
        this.blob = new FBBlob(this.gdsHelper, this.field.decodeLong(this.getFieldData()));
        return this.blob;
    }

    public InputStream getBinaryStream() throws SQLException {
        Blob blob = this.getBlob();
        if (blob == BLOB_NULL_VALUE) {
            return STREAM_NULL_VALUE;
        }
        return blob.getBinaryStream();
    }

    public byte[] getBytes() throws SQLException {
        Blob blob = this.getBlob();
        if (blob == BLOB_NULL_VALUE) {
            return BYTES_NULL_VALUE;
        }
        InputStream in = blob.getBinaryStream();
        if (in == STREAM_NULL_VALUE) {
            return BYTES_NULL_VALUE;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buff = new byte[4096];
        int counter = 0;
        try {
            while ((counter = in.read(buff)) != -1) {
                bout.write(buff, 0, counter);
            }
        }
        catch (IOException ioex) {
            throw (SQLException)FBLongVarCharField.createException(BYTES_CONVERSION_ERROR + " " + ioex.getMessage());
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ioex) {
                throw new FBSQLException(ioex);
            }
            try {
                bout.close();
            }
            catch (IOException ioex) {
                throw new FBSQLException(ioex);
            }
        }
        return bout.toByteArray();
    }

    public byte[] getCachedObject() throws SQLException {
        if (this.getFieldData() == null) {
            return BYTES_NULL_VALUE;
        }
        return this.getBytes();
    }

    public String getString() throws SQLException {
        byte[] data = this.getBytes();
        if (data == BYTES_NULL_VALUE) {
            return STRING_NULL_VALUE;
        }
        return this.field.decodeString(data, this.javaEncoding, this.mappingPath);
    }

    public void setBlob(FBBlob blob) throws SQLException {
        this.setFieldData(this.field.encodeLong(blob.getBlobId()));
        this.blob = blob;
    }

    public void setCharacterStream(Reader in, int length) throws SQLException {
        if (in == READER_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.binaryStream = null;
        this.characterStream = in;
        this.bytes = null;
        this.length = length;
    }

    public void setString(String value) throws SQLException {
        if (value == STRING_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setBytes(this.field.encodeString(value, this.javaEncoding, this.mappingPath));
    }

    public void setBytes(byte[] value) throws SQLException {
        if (value == BYTES_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.binaryStream = null;
        this.characterStream = null;
        this.bytes = value;
        this.length = value.length;
    }

    public void setBinaryStream(InputStream in, int length) throws SQLException {
        if (in == STREAM_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.binaryStream = in;
        this.characterStream = null;
        this.bytes = null;
        this.length = length;
    }

    public void flushCachedData() throws SQLException {
        if (this.binaryStream != null) {
            this.copyBinaryStream(this.binaryStream, this.length);
        } else if (this.characterStream != null) {
            this.copyCharacterStream(this.characterStream, this.length, this.javaEncoding);
        } else if (this.bytes != null) {
            this.copyBytes(this.bytes, this.length);
        } else if (this.blob == null) {
            this.setNull();
        }
        this.characterStream = null;
        this.binaryStream = null;
        this.bytes = null;
        this.length = 0;
    }

    private void copyBinaryStream(InputStream in, int length) throws SQLException {
        FBBlob blob = new FBBlob(this.gdsHelper);
        blob.copyStream(in, length);
        this.setFieldData(this.field.encodeLong(blob.getBlobId()));
    }

    private void copyCharacterStream(Reader in, int length, String encoding) throws SQLException {
        FBBlob blob = new FBBlob(this.gdsHelper);
        blob.copyCharacterStream(in, length, encoding);
        this.setFieldData(this.field.encodeLong(blob.getBlobId()));
    }

    private void copyBytes(byte[] bytes, int length) throws SQLException {
        FBBlob blob = new FBBlob(this.gdsHelper);
        blob.copyBytes(bytes, 0, length);
        this.setFieldData(this.field.encodeLong(blob.getBlobId()));
    }
}

