/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import javax.resource.ResourceException;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.jca.FBResourceException;

public class FBSQLException
extends SQLException {
    public static final String SQL_STATE_INVALID_CONN_ATTR = "01S00";
    public static final String SQL_STATE_NO_ROW_AVAIL = "01S06";
    public static final String SQL_STATE_GENERAL_ERROR = "HY000";
    public static final String SQL_STATE_INVALID_COLUMN = "HY002";
    public static final String SQL_STATE_INVALID_PARAM_TYPE = "HY105";
    public static final String SQL_STATE_INVALID_ARG_VALUE = "HY009";
    public static final String SQL_STATE_WRONG_PARAM_NUM = "07001";
    public static final String SQL_STATE_NO_RESULT_SET = "07005";
    public static final String SQL_STATE_INVALID_CONVERSION = "07006";
    public static final String SQL_STATE_CONNECTION_CLOSED = "08003";
    public static final String SQL_STATE_CONNECTION_FAILURE_IN_TX = "08007";
    public static final String SQL_STATE_COMM_LINK_FAILURE = "08S01";
    private Exception original;
    private String message;

    public FBSQLException(Exception ex) {
        super(ex.getMessage(), SQL_STATE_GENERAL_ERROR);
        this.original = ex;
        this.message = "Exception. " + ex.getMessage();
    }

    public FBSQLException(IOException ioex) {
        super(ioex.getMessage(), SQL_STATE_GENERAL_ERROR);
        this.original = ioex;
        this.message = "I/O Exception. " + ioex.getMessage();
    }

    public FBSQLException(GDSException ex) {
        super(ex.getMessage(), SQL_STATE_GENERAL_ERROR);
        this.original = ex;
        this.message = "GDS Exception. " + ex.getIntParam() + ". " + ex.getMessage();
    }

    public FBSQLException(ResourceException ex) {
        super(ex.getMessage(), ex.getErrorCode() != null ? ex.getErrorCode() : SQL_STATE_GENERAL_ERROR);
        FBResourceException rex;
        this.original = ex instanceof FBResourceException ? ((rex = (FBResourceException)ex).getLinkedException() != null ? rex.getLinkedException() : rex) : ex;
        this.message = this.original instanceof GDSException ? "GDS Exception. " + ((GDSException)this.original).getIntParam() + ". " + ex.getMessage() : "Resource Exception. " + ex.getMessage();
    }

    public FBSQLException(String message) {
        super(message, SQL_STATE_GENERAL_ERROR);
        this.message = message;
    }

    public FBSQLException(String message, String sqlState) {
        super(message, sqlState);
        this.message = message;
    }

    public int getErrorCode() {
        if (this.original instanceof GDSException) {
            return ((GDSException)this.original).getIntParam();
        }
        return 0;
    }

    public Exception getInternalException() {
        return this.original;
    }

    public String getMessage() {
        return this.message;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        if (this.original != null) {
            s.print("at ");
            this.original.printStackTrace(s);
        }
    }

    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        if (this.original != null) {
            s.print("at ");
            this.original.printStackTrace(s);
        }
    }
}

