/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.jni;

import org.firebirdsql.gds.GDS;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.impl.GDSFactoryPlugin;
import org.firebirdsql.gds.impl.jni.EmbeddedGDSImpl;
import org.firebirdsql.gds.impl.jni.GDSSynchronizationPolicy;
import org.firebirdsql.jdbc.FBConnection;

public class EmbeddedGDSFactoryPlugin
implements GDSFactoryPlugin {
    private static final String[] TYPE_ALIASES = new String[0];
    private static final String[] JDBC_PROTOCOLS = new String[]{"jdbc:firebirdsql:embedded:"};
    private static GDS gds;

    public String getPluginName() {
        return "GDS implementation for embedded server.";
    }

    public String getTypeName() {
        return "EMBEDDED";
    }

    public String[] getTypeAliases() {
        return TYPE_ALIASES;
    }

    public Class getConnectionClass() {
        return FBConnection.class;
    }

    public String[] getSupportedProtocols() {
        return JDBC_PROTOCOLS;
    }

    public synchronized GDS getGDS() {
        if (gds == null) {
            gds = EmbeddedGDSFactoryPlugin.applySyncPolicy(new EmbeddedGDSImpl());
        }
        return gds;
    }

    public static GDS applySyncPolicy(GDS tempGds) {
        GDSSynchronizationPolicy.ClientLibrarySyncPolicy syncPolicy = null;
        String osName = System.getProperty("os.name");
        if (osName != null && osName.indexOf("Windows") == -1) {
            syncPolicy = new GDSSynchronizationPolicy.ClientLibrarySyncPolicy(tempGds);
        }
        if (syncPolicy != null) {
            return GDSSynchronizationPolicy.applySyncronizationPolicy(tempGds, syncPolicy);
        }
        return tempGds;
    }

    public String getDatabasePath(String server, Integer port, String path) throws GDSException {
        return path;
    }

    public String getDatabasePath(String jdbcUrl) throws GDSException {
        String[] protocols = this.getSupportedProtocols();
        for (int i = 0; i < protocols.length; ++i) {
            if (!jdbcUrl.startsWith(protocols[i])) continue;
            return jdbcUrl.substring(protocols[i].length());
        }
        throw new IllegalArgumentException("Incorrect JDBC protocol handling: " + jdbcUrl);
    }

    public String getDefaultProtocol() {
        return this.getSupportedProtocols()[0];
    }

    public int hashCode() {
        return this.getTypeName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof EmbeddedGDSFactoryPlugin;
    }
}

