/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.firebirdsql.gds.GDS;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.impl.GDSFactoryPlugin;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.gds.impl.wire.JavaGDSImpl;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class GDSFactory {
    private static Logger log;
    private static HashSet registeredPlugins;
    private static HashMap typeToPluginMap;
    private static TreeMap jdbcUrlToPluginMap;
    private static GDSType defaultType;

    private static void loadPluginsFromClassLoader(ClassLoader classLoader) throws IOException {
        Enumeration<URL> res = classLoader.getResources("META-INF/services/" + GDSFactoryPlugin.class.getName());
        while (res.hasMoreElements()) {
            URL url = res.nextElement();
            InputStreamReader rin = new InputStreamReader(url.openStream());
            BufferedReader bin = new BufferedReader(rin);
            while (bin.ready()) {
                String className = bin.readLine();
                try {
                    Class<?> clazz = Class.forName(className);
                    GDSFactoryPlugin plugin = (GDSFactoryPlugin)clazz.newInstance();
                    GDSFactory.registerPlugin(plugin);
                }
                catch (ClassNotFoundException ex) {
                    if (log == null) continue;
                    log.error("Can't register plugin" + className, ex);
                }
                catch (IllegalAccessException ex) {
                    if (log == null) continue;
                    log.error("Can't register plugin" + className, ex);
                }
                catch (InstantiationException ex) {
                    if (log == null) continue;
                    log.error("Can't register plugin" + className, ex);
                }
            }
        }
    }

    public static void registerPlugin(GDSFactoryPlugin plugin) {
        boolean newPlugin = registeredPlugins.add(plugin);
        if (!newPlugin) {
            return;
        }
        GDSType type = GDSType.registerType(plugin.getTypeName());
        typeToPluginMap.put(type, plugin);
        if (defaultType == null) {
            defaultType = type;
        }
        String[] aliases = plugin.getTypeAliases();
        for (int i = 0; i < aliases.length; ++i) {
            GDSType aliasType = GDSType.registerType(aliases[i]);
            typeToPluginMap.put(aliasType, plugin);
        }
        String[] jdbcUrls = plugin.getSupportedProtocols();
        for (int i = 0; i < jdbcUrls.length; ++i) {
            GDSFactoryPlugin otherPlugin = jdbcUrlToPluginMap.put(jdbcUrls[i], plugin);
            if (otherPlugin == null || otherPlugin.equals(plugin)) continue;
            throw new IllegalArgumentException("Duplicate JDBC URL pattern detected: URL " + jdbcUrls[i] + ", " + "plugin " + plugin.getTypeName() + ", other plugin " + otherPlugin.getTypeName());
        }
    }

    public static GDS getDefaultGDS() {
        return GDSFactory.getGDSForType(defaultType);
    }

    public static GDSType getDefaultGDSType() {
        return defaultType;
    }

    public static synchronized GDS getGDSForType(GDSType gdsType) {
        GDSFactoryPlugin gdsPlugin;
        if (gdsType == null) {
            gdsType = defaultType;
        }
        if ((gdsPlugin = (GDSFactoryPlugin)typeToPluginMap.get(gdsType)) == null) {
            throw new IllegalArgumentException("Specified GDS type " + gdsType + " is unknown.");
        }
        return gdsPlugin.getGDS();
    }

    public static String getDatabasePath(GDSType gdsType, String server, Integer port, String path) throws GDSException {
        return GDSFactory.getPlugin(gdsType).getDatabasePath(server, port, path);
    }

    public static String getDatabasePath(GDSType gdsType, String jdbcUrl) throws GDSException {
        return GDSFactory.getPlugin(gdsType).getDatabasePath(jdbcUrl);
    }

    public static Set getSupportedProtocols() {
        return jdbcUrlToPluginMap.keySet();
    }

    public static String getJdbcUrl(GDSType gdsType, String databasePath) {
        return GDSFactory.getPlugin(gdsType).getDefaultProtocol() + databasePath;
    }

    public static GDSType getTypeForProtocol(String jdbcUrl) {
        for (Map.Entry entry : jdbcUrlToPluginMap.entrySet()) {
            String jdbcProtocol = (String)entry.getKey();
            GDSFactoryPlugin plugin = (GDSFactoryPlugin)entry.getValue();
            if (!jdbcUrl.startsWith(jdbcProtocol)) continue;
            return GDSType.getType(plugin.getTypeName());
        }
        return null;
    }

    public static Class getConnectionClass(GDSType gdsType) {
        return GDSFactory.getPlugin(gdsType).getConnectionClass();
    }

    private static GDSFactoryPlugin getPlugin(GDSType gdsType) {
        GDSFactoryPlugin gdsPlugin = (GDSFactoryPlugin)typeToPluginMap.get(gdsType);
        if (gdsPlugin == null) {
            throw new IllegalArgumentException("Specified GDS type " + gdsType + " is unknown.");
        }
        return gdsPlugin;
    }

    static {
        block4: {
            log = LoggerFactory.getLogger(JavaGDSImpl.class, false);
            registeredPlugins = new HashSet();
            typeToPluginMap = new HashMap();
            jdbcUrlToPluginMap = new TreeMap(new ReversedStringComparator());
            try {
                ClassLoader classLoader = GDSFactory.class.getClassLoader();
                if (classLoader == null) {
                    classLoader = ClassLoader.getSystemClassLoader();
                }
                GDSFactory.loadPluginsFromClassLoader(classLoader);
                classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader != null) {
                    GDSFactory.loadPluginsFromClassLoader(classLoader);
                }
            }
            catch (IOException ex) {
                if (log == null) break block4;
                log.error("Can't register plugins ", ex);
            }
        }
    }

    private static class ReversedStringComparator
    implements Comparator {
        private ReversedStringComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            return s2.compareTo(s1);
        }
    }
}

