/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.webcontainer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nextapp.echo.app.ApplicationInstance;
import nextapp.echo.app.util.Log;
import nextapp.echo.app.util.Uid;
import nextapp.echo.webcontainer.Connection;
import nextapp.echo.webcontainer.ContentType;
import nextapp.echo.webcontainer.ResourceRegistry;
import nextapp.echo.webcontainer.Service;
import nextapp.echo.webcontainer.ServiceRegistry;
import nextapp.echo.webcontainer.UserInstance;
import nextapp.echo.webcontainer.service.AsyncMonitorService;
import nextapp.echo.webcontainer.service.BootService;
import nextapp.echo.webcontainer.service.NewInstanceService;
import nextapp.echo.webcontainer.service.ResourceService;
import nextapp.echo.webcontainer.service.SessionExpiredService;
import nextapp.echo.webcontainer.service.StaticTextService;
import nextapp.echo.webcontainer.service.SynchronizeService;
import nextapp.echo.webcontainer.service.WindowHtmlService;

public abstract class WebContainerServlet
extends HttpServlet {
    public static final boolean DEBUG_PRINT_MESSAGES_TO_CONSOLE;
    private static final ThreadLocal activeConnection;
    public static final boolean DISABLE_CACHING = false;
    public static final boolean ENABLE_CLIENT_DEBUG_CONSOLE = true;
    public static final String SERVICE_ID_PARAMETER = "sid";
    public static final String SERVICE_ID_DEFAULT = "Echo.Default";
    public static final String SERVICE_ID_BLANK_DOCUMENT = "Echo.BlankDocument";
    public static final String SERVICE_ID_NEW_INSTANCE = "Echo.NewInstance";
    public static final String SERVICE_ID_SESSION_EXPIRED = "Echo.Expired";
    private static MultipartRequestWrapper multipartRequestWrapper;
    private static final long startupTime;
    private static final ResourceRegistry resources;
    private static final ServiceRegistry services;
    private List initScripts = null;
    private List initStyleSheets = null;

    public abstract ApplicationInstance newApplicationInstance();

    public static final Connection getActiveConnection() {
        return (Connection)activeConnection.get();
    }

    public static MultipartRequestWrapper getMultipartRequestWrapper() {
        return multipartRequestWrapper;
    }

    public static ResourceRegistry getResourceRegistry() {
        return resources;
    }

    public static ServiceRegistry getServiceRegistry() {
        return services;
    }

    public static final void setMultipartRequestWrapper(MultipartRequestWrapper multipartRequestWrapper) {
        if (WebContainerServlet.multipartRequestWrapper == null) {
            WebContainerServlet.multipartRequestWrapper = multipartRequestWrapper;
        } else if (multipartRequestWrapper == null || !WebContainerServlet.multipartRequestWrapper.getClass().getName().equals(multipartRequestWrapper.getClass().getName())) {
            throw new IllegalStateException("MultipartRequestWrapper already set.");
        }
    }

    public WebContainerServlet() {
        services.add(NewInstanceService.INSTANCE);
        services.add(SessionExpiredService.INSTANCE);
        services.add(SynchronizeService.INSTANCE);
        services.add(WindowHtmlService.INSTANCE);
        services.add(AsyncMonitorService.INSTANCE);
    }

    protected void addInitScript(Service service) {
        if (this.initScripts == null) {
            this.initScripts = new ArrayList();
        } else if (this.initScripts.contains(service)) {
            return;
        }
        services.add(service);
        this.initScripts.add(service);
    }

    protected void addInitStyleSheet(Service service) {
        if (this.initStyleSheets == null) {
            this.initStyleSheets = new ArrayList();
        } else if (this.initStyleSheets.contains(service)) {
            return;
        }
        services.add(service);
        this.initStyleSheets.add(service);
    }

    public final void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.process(request, response);
    }

    public final void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.process(request, response);
    }

    private static Service getService(UserInstance userInstance, String id) {
        Service service = services.get(id);
        if (id == null) {
            id = userInstance == null ? SERVICE_ID_NEW_INSTANCE : SERVICE_ID_DEFAULT;
        } else if (userInstance == null) {
            id = SERVICE_ID_SESSION_EXPIRED;
        }
        service = services.get(id);
        if (service == null) {
            if (SERVICE_ID_DEFAULT.equals(id)) {
                throw new RuntimeException("Service not registered: SERVICE_ID_DEFAULT");
            }
            if (SERVICE_ID_NEW_INSTANCE.equals(id)) {
                throw new RuntimeException("Service not registered: SERVICE_ID_NEW_INSTANCE");
            }
            if (SERVICE_ID_SESSION_EXPIRED.equals(id)) {
                throw new RuntimeException("Service not registered: SERVICE_ID_SESSION_EXPIRED");
            }
        }
        return service;
    }

    public Iterator getInitScripts() {
        return this.initScripts == null ? null : Collections.unmodifiableCollection(this.initScripts).iterator();
    }

    public Iterator getInitStyleSheets() {
        return this.initStyleSheets == null ? null : Collections.unmodifiableCollection(this.initStyleSheets).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Connection conn = null;
        try {
            conn = new Connection(this, request, response);
            activeConnection.set(conn);
            String serviceId = request.getParameter(SERVICE_ID_PARAMETER);
            Service service = WebContainerServlet.getService(conn.getUserInstance(), serviceId);
            if (service == null) {
                throw new ServletException("Service id \"" + serviceId + "\" not registered.");
            }
            int version = service.getVersion();
            if (version != -1) {
                response.setHeader("Cache-Control", "max-age=3600");
                response.setDateHeader("Expires", System.currentTimeMillis() + 86400000L);
                response.setDateHeader("Last-Modified", startupTime);
            } else {
                response.setHeader("Pragma", "no-cache");
                response.setHeader("Cache-Control", "no-store");
                response.setHeader("Expires", "0");
            }
            service.service(conn);
        }
        catch (ServletException ex) {
            if (conn != null) {
                conn.disposeUserInstance();
            }
            this.processError(request, response, (Exception)((Object)ex));
        }
        catch (IOException ex) {
            if (conn != null) {
                conn.disposeUserInstance();
            }
            this.processError(request, response, ex);
        }
        catch (RuntimeException ex) {
            if (conn != null) {
                conn.disposeUserInstance();
            }
            this.processError(request, response, ex);
        }
        finally {
            activeConnection.set(null);
        }
    }

    private void processError(HttpServletRequest request, HttpServletResponse response, Exception ex) throws ServletException, IOException {
        String exceptionId = Uid.generateUidString();
        Log.log((String)("Server Exception. ID: " + exceptionId), (Throwable)ex);
        response.setContentType("text/plain");
        response.setStatus(500);
        response.getWriter().write("Server Exception. ID: " + exceptionId);
    }

    static {
        boolean value;
        try {
            value = "true".equals(System.getProperty("echo.syncdump"));
        }
        catch (SecurityException ex) {
            value = false;
        }
        DEBUG_PRINT_MESSAGES_TO_CONSOLE = value;
        activeConnection = new ThreadLocal();
        startupTime = System.currentTimeMillis();
        resources = new ResourceRegistry();
        services = new ServiceRegistry();
        BootService.install(services);
        resources.addPackage("Echo", "nextapp/echo/webcontainer/resource/");
        resources.add("Echo", "resource/Transparent.gif", ContentType.IMAGE_GIF);
        resources.add("Echo", "resource/Blank.html", ContentType.TEXT_HTML);
        services.add(ResourceService.INSTANCE);
        services.add(new StaticTextService(SERVICE_ID_BLANK_DOCUMENT, "text/html", "<html></html>"));
    }

    public static interface MultipartRequestWrapper {
        public HttpServletRequest getWrappedRequest(HttpServletRequest var1) throws IOException, ServletException;
    }
}

