/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.webcontainer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import nextapp.echo.app.ApplicationInstance;
import nextapp.echo.app.Component;
import nextapp.echo.app.TaskQueueHandle;
import nextapp.echo.app.update.ServerComponentUpdate;
import nextapp.echo.app.update.UpdateManager;
import nextapp.echo.webcontainer.ClientConfiguration;
import nextapp.echo.webcontainer.ClientProperties;
import nextapp.echo.webcontainer.Connection;
import nextapp.echo.webcontainer.ContainerContext;
import nextapp.echo.webcontainer.ContainerContextImpl;
import nextapp.echo.webcontainer.RenderState;
import nextapp.echo.webcontainer.Service;
import nextapp.echo.webcontainer.WebContainerServlet;
import nextapp.echo.webcontainer.util.IdTable;

public class UserInstance
implements HttpSessionActivationListener,
HttpSessionBindingListener,
Serializable {
    private static final long serialVersionUID = 20070101L;
    private static final int DEFAULT_CALLBACK_INTERVAL = 500;
    public static final String PROPERTY_CLIENT_CONFIGURATION = "clientConfiguration";
    private ApplicationInstance applicationInstance;
    private String characterEncoding = "UTF-8";
    private ClientConfiguration clientConfiguration;
    private ClientProperties clientProperties;
    private Map componentToRenderStateMap = new HashMap();
    private PropertyChangeListener applicationPropertyChangeListener = new SerializablePropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent e) {
            if ("styleSheet".equals(e.getPropertyName())) {
                UserInstance.this.updatedPropertyNames.add("styleSheet");
            }
        }
    };
    private transient IdTable idTable;
    private boolean initialized = false;
    private boolean applicationInitialized = false;
    private Map initialRequestParameterMap;
    private Set updatedPropertyNames = new HashSet();
    private String servletUri;
    private transient HttpSession session;
    private transient Map taskQueueToCallbackIntervalMap;
    private int transactionId = 0;

    public static void newInstance(Connection conn) {
        new UserInstance(conn);
    }

    public UserInstance(Connection conn) {
        conn.initUserInstance(this);
        this.initialRequestParameterMap = new HashMap(conn.getRequest().getParameterMap());
    }

    public void clearRenderStates() {
        this.componentToRenderStateMap.clear();
    }

    public ApplicationInstance getApplicationInstance() {
        return this.applicationInstance;
    }

    public int getCallbackInterval() {
        if (this.taskQueueToCallbackIntervalMap == null || this.taskQueueToCallbackIntervalMap.size() == 0) {
            return 500;
        }
        Iterator it = this.taskQueueToCallbackIntervalMap.values().iterator();
        int returnInterval = Integer.MAX_VALUE;
        while (it.hasNext()) {
            int interval = (Integer)it.next();
            if (interval >= returnInterval) continue;
            returnInterval = interval;
        }
        return returnInterval;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public ClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }

    public ClientProperties getClientProperties() {
        return this.clientProperties;
    }

    public String getClientRenderId(Component component) {
        return "C." + component.getRenderId();
    }

    public Component getComponentByClientRenderId(String clientRenderId) {
        try {
            return this.applicationInstance.getComponentByRenderId(clientRenderId.substring(2));
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalArgumentException("Invalid component element id: " + clientRenderId);
        }
    }

    public int getCurrentTransactionId() {
        return this.transactionId;
    }

    public IdTable getIdTable() {
        if (this.idTable == null) {
            this.idTable = new IdTable();
        }
        return this.idTable;
    }

    public Map getInitialRequestParameterMap() {
        return this.initialRequestParameterMap;
    }

    public int getNextTransactionId() {
        ++this.transactionId;
        return this.transactionId;
    }

    public RenderState getRenderState(Component component) {
        return (RenderState)this.componentToRenderStateMap.get(component);
    }

    public String getRootHtmlElementId() {
        return "approot";
    }

    public String getServiceUri(Service service) {
        return this.servletUri + "?" + "sid" + "=" + service.getId();
    }

    public String getServiceUri(Service service, String[] parameterNames, String[] parameterValues) {
        StringBuffer out = new StringBuffer(this.servletUri);
        out.append("?");
        out.append("sid");
        out.append("=");
        out.append(service.getId());
        for (int i = 0; i < parameterNames.length; ++i) {
            out.append("&");
            out.append(parameterNames[i]);
            if (parameterValues[i] == null) continue;
            out.append("=");
            out.append(parameterValues[i]);
        }
        return out.toString();
    }

    public String getServletUri() {
        return this.servletUri;
    }

    public HttpSession getSession() {
        return this.session;
    }

    Iterator getUpdatedPropertyNames() {
        if (this.updatedPropertyNames.size() == 0) {
            return Collections.EMPTY_SET.iterator();
        }
        Set updatedPropertyNames = this.updatedPropertyNames;
        this.updatedPropertyNames = new HashSet();
        return updatedPropertyNames.iterator();
    }

    public UpdateManager getUpdateManager() {
        return this.applicationInstance.getUpdateManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.applicationInstance != null) {
            try {
                ApplicationInstance.setActive((ApplicationInstance)this.applicationInstance);
                this.applicationInstance.removePropertyChangeListener(this.applicationPropertyChangeListener);
                this.applicationInstance.dispose();
            }
            finally {
                ApplicationInstance.setActive(null);
            }
        }
    }

    public void init(Connection conn) {
        if (this.initialized) {
            throw new IllegalStateException("Attempt to invoke UserInstance.init() on initialized instance.");
        }
        WebContainerServlet servlet = conn.getServlet();
        this.applicationInstance = servlet.newApplicationInstance();
        this.applicationInstance.addPropertyChangeListener(this.applicationPropertyChangeListener);
        ContainerContextImpl containerContext = new ContainerContextImpl(this);
        this.applicationInstance.setContextProperty(ContainerContext.CONTEXT_PROPERTY_NAME, (Object)containerContext);
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepareApplicationInstance() {
        if (!this.applicationInitialized) {
            try {
                this.applicationInstance.doInit();
            }
            finally {
                this.applicationInitialized = true;
            }
        }
    }

    public void purgeRenderStates() {
        ServerComponentUpdate[] updates = this.getUpdateManager().getServerUpdateManager().getComponentUpdates();
        Iterator it = this.componentToRenderStateMap.keySet().iterator();
        while (it.hasNext()) {
            Component component = (Component)it.next();
            if (!component.isRegistered() || !component.isRenderVisible()) {
                it.remove();
                continue;
            }
            for (int i = 0; i < updates.length; ++i) {
                if (!updates[i].hasRemovedDescendant(component)) continue;
                it.remove();
            }
        }
    }

    public void removeRenderState(Component component) {
        this.componentToRenderStateMap.remove(component);
    }

    public void sessionDidActivate(HttpSessionEvent e) {
        this.session = e.getSession();
        if (this.applicationInstance != null) {
            this.applicationInstance.activate();
        }
    }

    public void sessionWillPassivate(HttpSessionEvent e) {
        if (this.applicationInstance != null) {
            this.applicationInstance.passivate();
        }
        this.session = null;
    }

    void setActive(boolean active) {
        if (active) {
            ApplicationInstance.setActive((ApplicationInstance)this.applicationInstance);
        } else {
            ApplicationInstance.setActive(null);
        }
    }

    public void setClientConfiguration(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
        this.updatedPropertyNames.add(PROPERTY_CLIENT_CONFIGURATION);
    }

    void setClientProperties(ClientProperties clientProperties) {
        this.clientProperties = clientProperties;
    }

    public void setRenderState(Component component, RenderState renderState) {
        this.componentToRenderStateMap.put(component, renderState);
    }

    void setServletUri(String servletUri) {
        this.servletUri = servletUri;
    }

    public void setTaskQueueCallbackInterval(TaskQueueHandle taskQueue, int ms) {
        if (this.taskQueueToCallbackIntervalMap == null) {
            this.taskQueueToCallbackIntervalMap = new WeakHashMap();
        }
        this.taskQueueToCallbackIntervalMap.put(taskQueue, new Integer(ms));
    }

    public void valueBound(HttpSessionBindingEvent e) {
        this.session = e.getSession();
    }

    public void valueUnbound(HttpSessionBindingEvent e) {
        this.dispose();
        this.session = null;
    }

    private abstract class SerializablePropertyChangeListener
    implements PropertyChangeListener,
    Serializable {
        private SerializablePropertyChangeListener() {
        }
    }
}

