/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.webcontainer;

import java.io.IOException;
import nextapp.echo.webcontainer.Connection;
import nextapp.echo.webcontainer.InputProcessor;
import nextapp.echo.webcontainer.OutputProcessor;
import nextapp.echo.webcontainer.SynchronizationState;
import nextapp.echo.webcontainer.UserInstance;

public class Synchronization
implements SynchronizationState {
    private Connection conn;
    private UserInstance userInstance;
    private boolean outOfSync = false;

    public Synchronization(Connection conn) {
        this.conn = conn;
        this.userInstance = conn.getUserInstance();
    }

    public boolean isOutOfSync() {
        return this.outOfSync;
    }

    public void setOutOfSync() {
        this.outOfSync = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() throws IOException {
        UserInstance userInstance = this.userInstance;
        synchronized (userInstance) {
            boolean initRequired;
            boolean bl = initRequired = !this.userInstance.isInitialized();
            if (initRequired) {
                this.userInstance.init(this.conn);
            }
            this.userInstance.setActive(true);
            try {
                InputProcessor inputProcessor = new InputProcessor(this, this.conn);
                inputProcessor.process();
                if (this.userInstance.getUpdateManager().getServerUpdateManager().isFullRefreshRequired()) {
                    this.userInstance.clearRenderStates();
                } else {
                    this.userInstance.purgeRenderStates();
                }
                OutputProcessor outputProcessor = new OutputProcessor(this, this.conn);
                outputProcessor.process();
                this.userInstance.getUpdateManager().purge();
            }
            finally {
                this.userInstance.setActive(false);
            }
        }
    }
}

