/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.webcontainer;

import java.util.HashSet;
import java.util.Set;
import nextapp.echo.app.util.DomUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServerMessage {
    public static final String GROUP_ID_INIT = "init";
    public static final String GROUP_ID_UPDATE = "update";
    private Set addedLibraries;
    private Element librariesElement;
    private Element serverMessageElement;
    private Document document = DomUtil.createDocument((String)"smsg", null, null, (String)"http://www.nextapp.com/products/echo/svrmsg/servermessage.3.0");

    public ServerMessage() {
        this.serverMessageElement = this.document.getDocumentElement();
        this.librariesElement = this.document.createElement("libs");
        this.serverMessageElement.appendChild(this.librariesElement);
        this.addPartGroup(GROUP_ID_INIT);
        this.addPartGroup(GROUP_ID_UPDATE);
    }

    public void addLibrary(String serviceId) {
        if (this.addedLibraries == null) {
            this.addedLibraries = new HashSet();
        }
        if (this.addedLibraries.contains(serviceId)) {
            return;
        }
        Element libraryElement = this.document.createElement("lib");
        libraryElement.appendChild(this.document.createTextNode(serviceId));
        this.librariesElement.appendChild(libraryElement);
        this.addedLibraries.add(serviceId);
    }

    public Element addPartGroup(String groupId) {
        Element messagePartGroupElement = this.document.createElement("group");
        messagePartGroupElement.setAttribute("i", groupId);
        this.serverMessageElement.appendChild(messagePartGroupElement);
        return messagePartGroupElement;
    }

    public Element getPartGroup(String groupId) {
        NodeList groupList = this.serverMessageElement.getElementsByTagName("group");
        int length = groupList.getLength();
        for (int i = 0; i < length; ++i) {
            Element groupElement = (Element)groupList.item(i);
            if (!groupId.equals(groupElement.getAttribute("i"))) continue;
            return groupElement;
        }
        return null;
    }

    public Element addDirective(String groupId, String processor) {
        Element messagePartGroupElement = this.getPartGroup(groupId);
        Element messagePartElement = this.document.createElement("dir");
        messagePartElement.setAttribute("proc", processor);
        messagePartGroupElement.appendChild(messagePartElement);
        return messagePartElement;
    }

    public Element addDirective(String groupId, String processor, String directiveName) {
        Element messagePartElement = null;
        Element groupElement = this.getPartGroup(groupId);
        Element lastChild = (Element)groupElement.getLastChild();
        messagePartElement = lastChild != null && processor.equals(lastChild.getAttribute("proc")) ? lastChild : this.addDirective(groupId, processor);
        Element directiveElement = this.document.createElement(directiveName);
        messagePartElement.appendChild(directiveElement);
        return directiveElement;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setAttribute(String attributeName, String attributeValue) {
        this.serverMessageElement.setAttribute(attributeName, attributeValue);
    }

    public void setResync() {
        this.serverMessageElement.setAttribute("resync", "true");
    }

    public void setTransactionId(long transactionId) {
        this.serverMessageElement.setAttribute("i", Long.toString(transactionId));
    }
}

