/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.webcontainer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import nextapp.echo.app.Command;
import nextapp.echo.app.Component;
import nextapp.echo.app.ContentPane;
import nextapp.echo.app.Style;
import nextapp.echo.app.StyleSheet;
import nextapp.echo.app.Window;
import nextapp.echo.app.reflect.ComponentIntrospector;
import nextapp.echo.app.reflect.IntrospectorFactory;
import nextapp.echo.app.serial.PropertyPeerFactory;
import nextapp.echo.app.serial.SerialException;
import nextapp.echo.app.serial.SerialPropertyPeer;
import nextapp.echo.app.update.ServerComponentUpdate;
import nextapp.echo.app.update.ServerUpdateManager;
import nextapp.echo.app.util.Context;
import nextapp.echo.app.util.DomUtil;
import nextapp.echo.app.util.Log;
import nextapp.echo.webcontainer.ClientConfiguration;
import nextapp.echo.webcontainer.CommandSynchronizePeer;
import nextapp.echo.webcontainer.ComponentSynchronizePeer;
import nextapp.echo.webcontainer.Connection;
import nextapp.echo.webcontainer.ContentType;
import nextapp.echo.webcontainer.PropertySerialPeerFactory;
import nextapp.echo.webcontainer.ServerMessage;
import nextapp.echo.webcontainer.SynchronizationContext;
import nextapp.echo.webcontainer.SynchronizationException;
import nextapp.echo.webcontainer.SynchronizationState;
import nextapp.echo.webcontainer.SynchronizePeerFactory;
import nextapp.echo.webcontainer.UserInstance;
import nextapp.echo.webcontainer.WebContainerServlet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

class OutputProcessor {
    private Connection conn;
    private UserInstance userInstance;
    private ServerMessage serverMessage;
    private ServerUpdateManager serverUpdateManager;
    private Context context;
    private PropertyPeerFactory propertyPeerFactory;
    private Document document;
    private int nextPropertyKey = 0;
    private Map propertyValueToKeyMap = null;
    private int nextStyleKey = 0;
    private Map styleValueToKeyMap = null;
    private Element rpElement;
    private Element rsElement;
    private SynchronizationState syncState;
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    static /* synthetic */ Class class$nextapp$echo$webcontainer$ServerMessage;
    static /* synthetic */ Class class$nextapp$echo$webcontainer$ClientConfiguration;
    static /* synthetic */ Class class$nextapp$echo$app$Component;

    public static String getClientLocaleString(Locale locale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        if (country.length() == 0) {
            return language;
        }
        return language + "-" + country;
    }

    public OutputProcessor(SynchronizationState syncState, Connection conn) {
        this.syncState = syncState;
        this.conn = conn;
        this.serverMessage = new ServerMessage();
        this.document = this.serverMessage.getDocument();
        this.context = new OutputContext();
        this.userInstance = conn.getUserInstance();
        this.serverUpdateManager = this.userInstance.getUpdateManager().getServerUpdateManager();
        this.propertyPeerFactory = PropertySerialPeerFactory.forClassLoader(this.classLoader);
    }

    public void process() throws IOException {
        this.serverMessage.setTransactionId(this.userInstance.getNextTransactionId());
        if (this.syncState.isOutOfSync()) {
            this.serverMessage.setResync();
        }
        try {
            if (this.serverUpdateManager.isFullRefreshRequired()) {
                this.renderApplicationFull();
                this.renderComponentsFull();
            } else {
                this.renderApplicationIncremental();
                this.renderComponentsIncremental();
            }
            this.renderCommands();
            this.renderFocus();
            this.renderAsyncState();
            this.conn.setContentType(ContentType.TEXT_XML);
            DomUtil.save((Document)this.serverMessage.getDocument(), (PrintWriter)this.conn.getWriter(), null);
        }
        catch (SerialException ex) {
            throw new SynchronizationException("Cannot serialize server state.", ex);
        }
        catch (SAXException ex) {
            throw new SynchronizationException("Cannot parse client XML.", ex);
        }
        if (WebContainerServlet.DEBUG_PRINT_MESSAGES_TO_CONSOLE) {
            try {
                System.err.println("======== Response: " + this.userInstance.getCurrentTransactionId() + " ========");
                DomUtil.save((Document)this.document, (OutputStream)System.err, (Properties)DomUtil.OUTPUT_PROPERTIES_INDENT);
                System.err.println();
            }
            catch (SAXException ex) {
                throw new SynchronizationException("Cannot render XML sync message to console.", ex);
            }
        }
    }

    private void renderAsyncState() {
        if (this.userInstance.getApplicationInstance().hasTaskQueues()) {
            this.serverMessage.setAttribute("async-interval", Integer.toString(this.userInstance.getCallbackInterval()));
        }
    }

    private void renderApplicationFull() throws SerialException {
        this.userInstance.getUpdatedPropertyNames();
        Element localeElement = this.serverMessage.addDirective("init", "AppSync", "locale");
        localeElement.appendChild(this.document.createTextNode(OutputProcessor.getClientLocaleString(this.userInstance.getApplicationInstance().getLocale())));
        Element layoutDirElement = this.serverMessage.addDirective("init", "AppSync", "dir");
        layoutDirElement.appendChild(this.document.createTextNode(this.userInstance.getApplicationInstance().getLayoutDirection().isLeftToRight() ? "ltr" : "rtl"));
        this.renderClientConfiguration();
    }

    private void renderApplicationIncremental() throws SerialException {
        Iterator it = this.userInstance.getUpdatedPropertyNames();
        while (it.hasNext()) {
            String propertyName = (String)it.next();
            if ("clientConfiguration".equals(propertyName)) {
                this.renderClientConfiguration();
                continue;
            }
            if (!"styleSheet".equals(propertyName)) continue;
            this.renderStyleSheet();
        }
    }

    private void renderClientConfiguration() throws SerialException {
        ClientConfiguration config = this.userInstance.getClientConfiguration();
        if (config == null) {
            return;
        }
        Element configElement = this.serverMessage.addDirective("init", "AppSync", "config");
        String[] propertyNames = config.getPropertyNames();
        for (int i = 0; i < propertyNames.length; ++i) {
            Element pElement = this.document.createElement("p");
            pElement.setAttribute("n", propertyNames[i]);
            Object propertyValue = config.getProperty(propertyNames[i]);
            if (propertyValue == null) {
                pElement.setAttribute("t", "0");
            } else {
                SerialPropertyPeer propertySyncPeer = this.propertyPeerFactory.getPeerForProperty(propertyValue.getClass());
                if (propertySyncPeer == null) continue;
                propertySyncPeer.toXml(this.context, class$nextapp$echo$webcontainer$ClientConfiguration == null ? OutputProcessor.class$("nextapp.echo.webcontainer.ClientConfiguration") : class$nextapp$echo$webcontainer$ClientConfiguration, pElement, propertyValue);
            }
            configElement.appendChild(pElement);
        }
    }

    private void renderCommands() throws SerialException {
        Command[] commands = this.serverUpdateManager.getCommands();
        for (int i = 0; i < commands.length; ++i) {
            CommandSynchronizePeer commandPeer = SynchronizePeerFactory.getPeerForCommand(commands[i].getClass());
            if (commandPeer == null) {
                throw new IllegalStateException("No synchronize peer found for command: " + commands[i].getClass().getName());
            }
            commandPeer.init(this.context);
            Element commandExecuteElement = this.serverMessage.addDirective("update", "CmdExec", "cmd");
            commandExecuteElement.setAttribute("t", commandPeer.getClientCommandType());
            Iterator propertyNameIt = commandPeer.getPropertyNames(this.context, commands[i]);
            while (propertyNameIt.hasNext()) {
                String propertyName = (String)propertyNameIt.next();
                if (commandPeer.isPropertyIndexed(this.context, commands[i], propertyName)) {
                    Iterator propertyIndexIt = commandPeer.getPropertyIndices(this.context, commands[i], propertyName);
                    while (propertyIndexIt.hasNext()) {
                        int propertyIndex = (Integer)propertyIndexIt.next();
                        this.renderCommandProperty(commandExecuteElement, commandPeer, commands[i], propertyName, propertyIndex);
                    }
                    continue;
                }
                this.renderCommandProperty(commandExecuteElement, commandPeer, commands[i], propertyName, -1);
            }
        }
    }

    private void renderCommandProperty(Element commandExecuteElement, CommandSynchronizePeer commandPeer, Command command, String propertyName, int propertyIndex) throws SerialException {
        Object propertyValue;
        Element pElement = this.document.createElement("p");
        pElement.setAttribute("n", propertyName);
        if (propertyIndex != -1) {
            pElement.setAttribute("x", Integer.toString(propertyIndex));
        }
        if ((propertyValue = commandPeer.getProperty(this.context, command, propertyName, propertyIndex)) == null) {
            pElement.setAttribute("t", "0");
        } else {
            SerialPropertyPeer propertySyncPeer = this.propertyPeerFactory.getPeerForProperty(propertyValue.getClass());
            if (propertySyncPeer == null) {
                return;
            }
            propertySyncPeer.toXml(this.context, command.getClass(), pElement, propertyValue);
        }
        commandExecuteElement.appendChild(pElement);
    }

    private void renderComponentsFull() throws SerialException {
        Window window = this.userInstance.getApplicationInstance().getDefaultWindow();
        this.serverMessage.addDirective("init", "CSyncIn", "cl");
        this.serverMessage.setAttribute("root", this.userInstance.getRootHtmlElementId());
        this.renderStyleSheet();
        ContentPane content = window.getContent();
        if (content == null) {
            throw new IllegalStateException("No content to render: default window has no content.");
        }
        Element upElement = this.serverMessage.addDirective("update", "CSyncUp", "up");
        upElement.setAttribute("r", "true");
        this.renderComponentState(upElement, (Component)content);
        ComponentSynchronizePeer componentPeer = SynchronizePeerFactory.getPeerForComponent(window.getClass());
        if (componentPeer == null) {
            throw new IllegalStateException("No synchronize peer found for component: " + window.getClass().getName());
        }
        Iterator propertyNameIterator = componentPeer.getOutputPropertyNames(this.context, (Component)window);
        while (propertyNameIterator.hasNext()) {
            String propertyName = (String)propertyNameIterator.next();
            this.renderComponentProperty(upElement, componentPeer, (Component)window, propertyName, false);
        }
    }

    private void renderComponentsIncremental() throws SerialException {
        int i;
        ServerComponentUpdate[] componentUpdates = this.serverUpdateManager.getComponentUpdates();
        for (i = 0; i < componentUpdates.length; ++i) {
            if (componentUpdates[i] == null || !componentUpdates[i].hasRemovedChildren()) continue;
            Element rmElement = this.serverMessage.addDirective("update", "CSyncRm", "rm");
            Component parentComponent = componentUpdates[i].getParent();
            this.setComponentId(rmElement, parentComponent);
            Component[] removedChildren = componentUpdates[i].getRemovedChildren();
            HashSet<String> removedIdSet = new HashSet<String>();
            StringBuffer out = new StringBuffer();
            for (int j = 0; j < removedChildren.length; ++j) {
                String renderId = this.userInstance.getClientRenderId(removedChildren[j]);
                if (removedIdSet.contains(renderId)) continue;
                if (j > 0) {
                    out.append(",");
                }
                out.append(renderId);
                removedIdSet.add(renderId);
            }
            rmElement.setAttribute("rm", out.toString());
        }
        for (i = 0; i < componentUpdates.length; ++i) {
            if (componentUpdates[i] == null) continue;
            if (componentUpdates[i].hasAddedChildren() || componentUpdates[i].hasUpdatedProperties()) {
                Component parentComponent = componentUpdates[i].getParent();
                Element upElement = this.serverMessage.addDirective("update", "CSyncUp", "up");
                this.setComponentId(upElement, parentComponent);
                Component[] addedChildren = componentUpdates[i].getAddedChildren();
                if (addedChildren.length > 0) {
                    TreeMap<Integer, Component> indexedComponents = new TreeMap<Integer, Component>();
                    for (int j = 0; j < addedChildren.length; ++j) {
                        Component addedChild = addedChildren[j];
                        indexedComponents.put(new Integer(parentComponent.visibleIndexOf(addedChild)), addedChild);
                    }
                    Iterator indexedComponentsIter = indexedComponents.entrySet().iterator();
                    int lastIndex = Integer.MIN_VALUE;
                    while (indexedComponentsIter.hasNext()) {
                        Map.Entry entry = indexedComponentsIter.next();
                        Element cElement = this.renderComponentState(upElement, (Component)entry.getValue());
                        int index = (Integer)entry.getKey();
                        if (index != lastIndex + 1) {
                            cElement.setAttribute("x", Integer.toString(index));
                        }
                        lastIndex = index;
                    }
                }
                this.renderComponentUpdatedProperties(upElement, parentComponent, componentUpdates[i]);
            }
            if (!componentUpdates[i].hasUpdatedLayoutDataChildren()) continue;
            Component[] updatedLayoutDataChildren = componentUpdates[i].getUpdatedLayoutDataChildren();
            for (int j = 0; j < updatedLayoutDataChildren.length; ++j) {
                Component component = updatedLayoutDataChildren[j];
                ComponentSynchronizePeer componentPeer = SynchronizePeerFactory.getPeerForComponent(component.getClass());
                if (componentPeer == null) {
                    throw new IllegalStateException("No synchronize peer found for component: " + component.getClass().getName());
                }
                Element upElement = this.serverMessage.addDirective("update", "CSyncUp", "up");
                this.setComponentId(upElement, component);
                this.renderComponentProperty(upElement, componentPeer, component, "layoutData", true);
            }
        }
    }

    private void renderComponentProperty(Element parentElement, ComponentSynchronizePeer componentPeer, Component c, String propertyName, boolean renderNulls) throws SerialException {
        boolean indexedProperty = componentPeer.isOutputPropertyIndexed(this.context, c, propertyName);
        if (indexedProperty) {
            Iterator indicesIt = componentPeer.getOutputPropertyIndices(this.context, c, propertyName);
            if (indicesIt == null) {
                return;
            }
            while (indicesIt.hasNext()) {
                int index = (Integer)indicesIt.next();
                this.renderComponentPropertyImpl(parentElement, componentPeer, c, propertyName, index, renderNulls);
            }
        } else {
            this.renderComponentPropertyImpl(parentElement, componentPeer, c, propertyName, -1, renderNulls);
        }
    }

    private void renderComponentPropertyImpl(Element parentElement, ComponentSynchronizePeer componentPeer, Component c, String propertyName, int propertyIndex, boolean renderNulls) throws SerialException {
        Element propertyDataElement;
        Object propertyValue = componentPeer.getOutputProperty(this.context, c, propertyName, propertyIndex);
        if (propertyValue == null && !renderNulls) {
            return;
        }
        Element pElement = this.document.createElement("p");
        String propertyKey = null;
        if (propertyValue != null && componentPeer.isOutputPropertyReferenced(this.context, c, propertyName)) {
            if (this.rpElement == null) {
                this.rpElement = this.serverMessage.addDirective("init", "CSyncUp", "rp");
            }
            if (this.propertyValueToKeyMap == null) {
                this.propertyValueToKeyMap = new HashMap();
            } else {
                propertyKey = (String)this.propertyValueToKeyMap.get(propertyValue);
            }
            if (propertyKey == null) {
                propertyKey = Integer.toString(this.nextPropertyKey++);
                this.propertyValueToKeyMap.put(propertyValue, propertyKey);
                propertyDataElement = this.document.createElement("p");
                propertyDataElement.setAttribute("i", propertyKey);
                this.rpElement.appendChild(propertyDataElement);
            } else {
                propertyDataElement = null;
            }
            pElement.setAttribute("r", propertyKey);
        } else {
            propertyDataElement = pElement;
        }
        String methodName = componentPeer.getOutputPropertyMethodName(this.context, c, propertyName);
        if (methodName != null) {
            pElement.setAttribute("m", methodName);
        } else {
            pElement.setAttribute("n", propertyName);
        }
        if (propertyIndex != -1) {
            pElement.setAttribute("x", Integer.toString(propertyIndex));
        }
        if (propertyValue == null) {
            pElement.setAttribute("t", "0");
        } else if (propertyDataElement != null) {
            SerialPropertyPeer propertySyncPeer = this.propertyPeerFactory.getPeerForProperty(propertyValue.getClass());
            if (propertySyncPeer == null) {
                return;
            }
            propertySyncPeer.toXml(this.context, c.getClass(), propertyDataElement, propertyValue);
        }
        parentElement.appendChild(pElement);
    }

    private Element renderComponentState(Element parentElement, Component c) throws SerialException {
        Document document = parentElement.getOwnerDocument();
        ComponentSynchronizePeer componentPeer = SynchronizePeerFactory.getPeerForComponent(c.getClass());
        if (componentPeer == null) {
            throw new IllegalStateException("No synchronize peer found for component: " + c.getClass().getName());
        }
        Element cElement = document.createElement("c");
        cElement.setAttribute("i", this.userInstance.getClientRenderId(c));
        cElement.setAttribute("t", componentPeer.getClientComponentType(true));
        componentPeer.init(this.context, c);
        this.renderComponentStyleName(cElement, c, false);
        this.renderComponentStyle(cElement, c, false);
        if (c.getFocusNextId() != null || c.getFocusPreviousId() != null) {
            Component focusComponent;
            Element fElement = document.createElement("f");
            if (c.getFocusNextId() != null && (focusComponent = c.getApplicationInstance().getComponentByRenderId(c.getFocusNextId())) != null) {
                fElement.setAttribute("n", this.userInstance.getClientRenderId(focusComponent));
            }
            if (c.getFocusPreviousId() != null && (focusComponent = c.getApplicationInstance().getComponentByRenderId(c.getFocusPreviousId())) != null) {
                fElement.setAttribute("p", this.userInstance.getClientRenderId(focusComponent));
            }
            cElement.appendChild(fElement);
        }
        if (!c.isEnabled()) {
            Element enElement = document.createElement("en");
            enElement.appendChild(document.createTextNode("false"));
            cElement.appendChild(enElement);
        }
        if (c.getLocale() != null) {
            Element localeElement = document.createElement("locale");
            localeElement.appendChild(document.createTextNode(OutputProcessor.getClientLocaleString(c.getLocale())));
            cElement.appendChild(localeElement);
        }
        if (c.getLayoutDirection() != null) {
            Element dirElement = document.createElement("dir");
            dirElement.appendChild(document.createTextNode(c.getLayoutDirection().isLeftToRight() ? "ltr" : "rtl"));
            cElement.appendChild(dirElement);
        }
        Iterator propertyNameIterator = componentPeer.getOutputPropertyNames(this.context, c);
        while (propertyNameIterator.hasNext()) {
            String propertyName = (String)propertyNameIterator.next();
            this.renderComponentProperty(cElement, componentPeer, c, propertyName, false);
        }
        Iterator eventTypeIterator = componentPeer.getEventTypes(this.context, c);
        while (eventTypeIterator.hasNext()) {
            String eventType = (String)eventTypeIterator.next();
            if (!componentPeer.hasListeners(this.context, c, eventType)) continue;
            Element eElement = document.createElement("e");
            eElement.setAttribute("t", eventType);
            cElement.appendChild(eElement);
        }
        Component[] children = c.getVisibleComponents();
        for (int i = 0; i < children.length; ++i) {
            this.renderComponentState(cElement, children[i]);
        }
        parentElement.appendChild(cElement);
        return cElement;
    }

    private void renderComponentStyle(Element element, Component c, boolean required) throws SerialException {
        Style style = c.getStyle();
        if (style == null) {
            if (required) {
                element.appendChild(this.document.createElement("sr"));
            }
            return;
        }
        if (this.rsElement == null) {
            this.rsElement = this.serverMessage.addDirective("init", "CSyncUp", "rs");
        }
        String styleKey = null;
        if (this.styleValueToKeyMap == null) {
            this.styleValueToKeyMap = new HashMap();
        } else {
            styleKey = (String)this.styleValueToKeyMap.get(style);
        }
        if (styleKey == null) {
            styleKey = Integer.toString(this.nextStyleKey++);
            this.styleValueToKeyMap.put(style, styleKey);
            Element sElement = this.document.createElement("s");
            sElement.setAttribute("i", styleKey);
            this.renderStyle(c.getClass(), sElement, style);
            this.rsElement.appendChild(sElement);
        }
        Element srElement = this.document.createElement("sr");
        srElement.appendChild(this.document.createTextNode(styleKey));
        element.appendChild(srElement);
    }

    private void renderComponentStyleName(Element element, Component c, boolean required) throws SerialException {
        Class<?> styleClass;
        StyleSheet styleSheet = c.getApplicationInstance().getStyleSheet();
        String styleName = c.getStyleName();
        if (styleSheet == null || !required && styleName == null) {
            return;
        }
        Style style = styleSheet.getStyle(styleName, styleClass, false);
        for (styleClass = c.getClass(); style == null && styleClass != (class$nextapp$echo$app$Component == null ? OutputProcessor.class$("nextapp.echo.app.Component") : class$nextapp$echo$app$Component); styleClass = styleClass.getSuperclass()) {
            style = styleSheet.getStyle(styleName, styleClass, false);
        }
        ComponentSynchronizePeer componentPeer = SynchronizePeerFactory.getPeerForComponent(styleClass, false);
        if (componentPeer == null) {
            componentPeer = SynchronizePeerFactory.getPeerForComponent(styleClass, true);
            if (componentPeer == null) {
                throw new SerialException("No peer available for component: " + styleClass.getName(), null);
            }
            Element sElement = this.document.createElement("s");
            sElement.appendChild(this.document.createTextNode((styleName == null ? "" : styleName) + ":" + styleClass.getName()));
            element.appendChild(sElement);
        } else {
            Element sElement = this.document.createElement("s");
            sElement.appendChild(this.document.createTextNode(styleName == null ? "" : styleName));
            element.appendChild(sElement);
        }
    }

    private void renderComponentUpdatedProperties(Element upElement, Component c, ServerComponentUpdate update) throws SerialException {
        ComponentSynchronizePeer componentPeer = SynchronizePeerFactory.getPeerForComponent(c.getClass());
        if (componentPeer == null) {
            throw new IllegalStateException("No synchronize peer found for component: " + c.getClass().getName());
        }
        Iterator propertyNameIt = componentPeer.getUpdatedOutputPropertyNames(this.context, c, update);
        while (propertyNameIt.hasNext()) {
            String propertyName = (String)propertyNameIt.next();
            this.renderComponentProperty(upElement, componentPeer, c, propertyName, true);
        }
        if (update.hasUpdatedProperties()) {
            if (update.hasUpdatedProperty("styleName")) {
                this.renderComponentStyleName(upElement, c, true);
            }
            if (update.hasUpdatedProperty("style")) {
                this.renderComponentStyle(upElement, c, true);
            }
            if (update.hasUpdatedProperty("enabled")) {
                Element enElement = this.document.createElement("en");
                enElement.appendChild(this.document.createTextNode(update.getParent().isEnabled() ? "true" : "false"));
                upElement.appendChild(enElement);
            }
            if (update.hasUpdatedProperty("locale")) {
                Element localeElement = this.document.createElement("locale");
                if (c.getLocale() != null) {
                    localeElement.appendChild(this.document.createTextNode(OutputProcessor.getClientLocaleString(c.getLocale())));
                }
                upElement.appendChild(localeElement);
            }
            if (update.hasUpdatedProperty("layoutDirection")) {
                Element dirElement = this.document.createElement("dir");
                if (c.getLayoutDirection() != null) {
                    dirElement.appendChild(this.document.createTextNode(c.getLayoutDirection().isLeftToRight() ? "ltr" : "rtl"));
                }
                upElement.appendChild(dirElement);
            }
        }
        Iterator eventTypeIterator = componentPeer.getEventTypes(this.context, c);
        while (eventTypeIterator.hasNext()) {
            String eventType = (String)eventTypeIterator.next();
            if (!componentPeer.hasUpdatedListeners(this.context, c, update, eventType)) continue;
            Element eElement = this.document.createElement("e");
            eElement.setAttribute("t", eventType);
            eElement.setAttribute("v", componentPeer.hasListeners(this.context, c, eventType) ? "true" : "false");
            upElement.appendChild(eElement);
        }
    }

    private void renderFocus() {
        Component focusedComponent = this.userInstance.getApplicationInstance().getFocusedComponent();
        if (focusedComponent != null) {
            Element focusElement = this.serverMessage.addDirective("update", "CFocus", "focus");
            focusElement.setAttribute("i", this.userInstance.getClientRenderId(focusedComponent));
        }
    }

    private void renderStyle(Class componentClass, Element sElement, Style style) throws SerialException {
        ComponentIntrospector ci;
        Document document = sElement.getOwnerDocument();
        try {
            ci = (ComponentIntrospector)IntrospectorFactory.get((String)componentClass.getName(), (ClassLoader)componentClass.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Internal error.", ex);
        }
        Iterator it = style.getPropertyNames();
        while (it.hasNext()) {
            String propertyName = (String)it.next();
            if (ci.isIndexedProperty(propertyName)) {
                Iterator indicesIt = style.getPropertyIndices(propertyName);
                while (indicesIt.hasNext()) {
                    int index = (Integer)indicesIt.next();
                    Object propertyValue = style.getIndex(propertyName, index);
                    if (propertyValue == null) continue;
                    SerialPropertyPeer propertySyncPeer = this.propertyPeerFactory.getPeerForProperty(propertyValue.getClass());
                    if (propertySyncPeer == null) {
                        Log.log((String)("No peer found for property class: " + propertyValue.getClass()));
                        continue;
                    }
                    Element pElement = document.createElement("p");
                    pElement.setAttribute("n", propertyName);
                    pElement.setAttribute("x", Integer.toString(index));
                    propertySyncPeer.toXml(this.context, componentClass, pElement, propertyValue);
                    sElement.appendChild(pElement);
                }
                continue;
            }
            Object propertyValue = style.get(propertyName);
            if (propertyValue == null) continue;
            SerialPropertyPeer propertySyncPeer = this.propertyPeerFactory.getPeerForProperty(propertyValue.getClass());
            if (propertySyncPeer == null) {
                Log.log((String)("No peer found for property class: " + propertyValue.getClass()));
                continue;
            }
            Element pElement = document.createElement("p");
            pElement.setAttribute("n", propertyName);
            propertySyncPeer.toXml(this.context, componentClass, pElement, propertyValue);
            sElement.appendChild(pElement);
        }
    }

    private void renderStyleSheet() throws SerialException {
        Element ssElement = this.serverMessage.addDirective("update", "CSyncUp", "ss");
        StyleSheet styleSheet = this.userInstance.getApplicationInstance().getStyleSheet();
        if (styleSheet == null) {
            return;
        }
        Document document = ssElement.getOwnerDocument();
        Iterator styleNameIterator = styleSheet.getStyleNames();
        while (styleNameIterator.hasNext()) {
            String styleName = (String)styleNameIterator.next();
            Iterator componentTypeIterator = styleSheet.getComponentTypes(styleName);
            while (componentTypeIterator.hasNext()) {
                Class componentClass = (Class)componentTypeIterator.next();
                Element sElement = document.createElement("s");
                ComponentSynchronizePeer componentPeer = SynchronizePeerFactory.getPeerForComponent(componentClass, false);
                if (componentPeer == null) {
                    componentPeer = SynchronizePeerFactory.getPeerForComponent(componentClass, true);
                    if (componentPeer == null) {
                        throw new SerialException("No peer available for component: " + componentClass.getName(), null);
                    }
                    sElement.setAttribute("n", (styleName == null ? "" : styleName) + ":" + componentClass.getName());
                } else if (styleName != null) {
                    sElement.setAttribute("n", styleName);
                }
                sElement.setAttribute("t", componentPeer.getClientComponentType(false));
                Style style = styleSheet.getStyle(styleName, componentClass, false);
                this.renderStyle(componentClass, sElement, style);
                ssElement.appendChild(sElement);
            }
        }
    }

    private void setComponentId(Element element, Component component) {
        if (component.getParent() == null) {
            element.setAttribute("r", "true");
        } else {
            element.setAttribute("i", this.userInstance.getClientRenderId(component));
        }
    }

    private class OutputContext
    extends SynchronizationContext {
        public OutputContext() {
            super(OutputProcessor.this.conn, OutputProcessor.this.document);
        }

        public Object get(Class specificContextClass) {
            if (specificContextClass == (class$nextapp$echo$webcontainer$ServerMessage == null ? (class$nextapp$echo$webcontainer$ServerMessage = OutputProcessor.class$("nextapp.echo.webcontainer.ServerMessage")) : class$nextapp$echo$webcontainer$ServerMessage)) {
                return OutputProcessor.this.serverMessage;
            }
            return super.get(specificContextClass);
        }
    }
}

