/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.webcontainer;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import nextapp.echo.app.update.UpdateManager;
import nextapp.echo.app.util.DomUtil;
import nextapp.echo.app.util.Log;
import nextapp.echo.webcontainer.ClientMessage;
import nextapp.echo.webcontainer.ClientPropertiesInputProcessor;
import nextapp.echo.webcontainer.ComponentFocusInputProcessor;
import nextapp.echo.webcontainer.ComponentInputProcessor;
import nextapp.echo.webcontainer.Connection;
import nextapp.echo.webcontainer.SynchronizationContext;
import nextapp.echo.webcontainer.SynchronizationException;
import nextapp.echo.webcontainer.SynchronizationState;
import nextapp.echo.webcontainer.UserInstance;
import nextapp.echo.webcontainer.WebContainerServlet;
import nextapp.echo.webcontainer.util.XmlRequestParser;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class InputProcessor {
    private Connection conn;
    private SynchronizationState syncState;
    private ClientMessage clientMessage;
    static /* synthetic */ Class class$nextapp$echo$webcontainer$ClientMessage;
    static /* synthetic */ Class class$nextapp$echo$app$update$ClientUpdateManager;

    public InputProcessor(SynchronizationState syncState, Connection conn) {
        this.syncState = syncState;
        this.conn = conn;
    }

    public void process() throws IOException {
        Document document = XmlRequestParser.parse(this.conn.getRequest(), this.conn.getUserInstance().getCharacterEncoding());
        this.clientMessage = new ClientMessage(document);
        UserInstance userInstance = this.conn.getUserInstance();
        UpdateManager updateManager = userInstance.getUpdateManager();
        InputContext context = new InputContext();
        if ("init".equals(this.clientMessage.getType())) {
            updateManager.getServerUpdateManager().processFullRefresh();
        } else if (this.clientMessage.getTransactionId() != userInstance.getCurrentTransactionId()) {
            updateManager.getServerUpdateManager().processFullRefresh();
            this.syncState.setOutOfSync();
            if (WebContainerServlet.DEBUG_PRINT_MESSAGES_TO_CONSOLE) {
                Log.log((String)("Client out of sync: client id = " + this.clientMessage.getTransactionId() + ", server id = " + userInstance.getCurrentTransactionId()));
            }
        }
        if (WebContainerServlet.DEBUG_PRINT_MESSAGES_TO_CONSOLE) {
            try {
                System.err.println("======== Request: " + userInstance.getCurrentTransactionId() + " ========");
                DomUtil.save((Document)this.clientMessage.getDocument(), (OutputStream)System.err, (Properties)DomUtil.OUTPUT_PROPERTIES_INDENT);
                System.err.println();
            }
            catch (SAXException ex) {
                throw new SynchronizationException("Cannot render XML sync message to console.", ex);
            }
        }
        if (!this.syncState.isOutOfSync()) {
            this.clientMessage.process(context);
        }
    }

    static {
        ClientMessage.register("CSync", ComponentInputProcessor.class);
        ClientMessage.register("ClientProperties", ClientPropertiesInputProcessor.class);
        ClientMessage.register("CFocus", ComponentFocusInputProcessor.class);
    }

    private class InputContext
    extends SynchronizationContext {
        public InputContext() {
            super(InputProcessor.this.conn, InputProcessor.this.clientMessage.getDocument());
        }

        public Object get(Class specificContextClass) {
            if (specificContextClass == (class$nextapp$echo$webcontainer$ClientMessage == null ? (class$nextapp$echo$webcontainer$ClientMessage = InputProcessor.class$("nextapp.echo.webcontainer.ClientMessage")) : class$nextapp$echo$webcontainer$ClientMessage)) {
                return InputProcessor.this.clientMessage;
            }
            if (specificContextClass == (class$nextapp$echo$app$update$ClientUpdateManager == null ? (class$nextapp$echo$app$update$ClientUpdateManager = InputProcessor.class$("nextapp.echo.app.update.ClientUpdateManager")) : class$nextapp$echo$app$update$ClientUpdateManager)) {
                return InputProcessor.this.conn.getUserInstance().getApplicationInstance().getUpdateManager().getClientUpdateManager();
            }
            return super.get(specificContextClass);
        }
    }
}

