/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.webcontainer;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nextapp.echo.app.Component;
import nextapp.echo.app.serial.PropertyPeerFactory;
import nextapp.echo.app.serial.SerialException;
import nextapp.echo.app.serial.SerialPropertyPeer;
import nextapp.echo.app.update.UpdateManager;
import nextapp.echo.app.util.Context;
import nextapp.echo.app.util.DomUtil;
import nextapp.echo.app.util.Log;
import nextapp.echo.webcontainer.ClientMessage;
import nextapp.echo.webcontainer.ComponentSynchronizePeer;
import nextapp.echo.webcontainer.SynchronizationException;
import nextapp.echo.webcontainer.SynchronizePeerFactory;
import nextapp.echo.webcontainer.UserInstance;
import org.w3c.dom.Element;

public class ComponentInputProcessor
implements ClientMessage.Processor {
    private Map componentUpdateMap = new HashMap();
    private String eventComponentId;
    private Element eventElement;
    private String eventType;

    private Element getEvent() {
        return this.eventElement;
    }

    private String getEventComponentId() {
        return this.eventComponentId;
    }

    private String getEventType() {
        return this.eventType;
    }

    private Iterator getUpdatedComponentIds() {
        return this.componentUpdateMap.keySet().iterator();
    }

    private Element getUpdatedProperty(String componentId, String propertyName) {
        Map propertyMap = (Map)this.componentUpdateMap.get(componentId);
        return (Element)propertyMap.get(propertyName);
    }

    private Iterator getUpdatedPropertyNames(String componentId) {
        Map propertyMap = (Map)this.componentUpdateMap.get(componentId);
        return propertyMap.keySet().iterator();
    }

    private void parseDirElement(Element dirElement) {
        this.eventElement = DomUtil.getChildElementByTagName((Element)dirElement, (String)"e");
        if (this.eventElement != null) {
            this.eventType = this.eventElement.getAttribute("t");
            this.eventComponentId = this.eventElement.getAttribute("i");
        }
        Element[] pElements = DomUtil.getChildElementsByTagName((Element)dirElement, (String)"p");
        for (int i = 0; i < pElements.length; ++i) {
            String componentId = pElements[i].getAttribute("i");
            String propertyName = pElements[i].getAttribute("n");
            HashMap<String, Element> propertyMap = (HashMap<String, Element>)this.componentUpdateMap.get(componentId);
            if (propertyMap == null) {
                propertyMap = new HashMap<String, Element>();
                this.componentUpdateMap.put(componentId, propertyMap);
            }
            propertyMap.put(propertyName, pElements[i]);
        }
    }

    public void process(Context context, Element dirElement) throws IOException {
        this.parseDirElement(dirElement);
        UserInstance userInstance = (UserInstance)context.get(UserInstance.class);
        userInstance.prepareApplicationInstance();
        PropertyPeerFactory propertyPeerFactory = (PropertyPeerFactory)context.get(PropertyPeerFactory.class);
        UpdateManager updateManager = userInstance.getApplicationInstance().getUpdateManager();
        Iterator updatedComponentIdIt = this.getUpdatedComponentIds();
        while (updatedComponentIdIt.hasNext()) {
            String componentId = (String)updatedComponentIdIt.next();
            Component component = userInstance.getComponentByClientRenderId(componentId);
            ComponentSynchronizePeer componentPeer = SynchronizePeerFactory.getPeerForComponent(component.getClass());
            Iterator updatedPropertyIt = this.getUpdatedPropertyNames(componentId);
            while (updatedPropertyIt.hasNext()) {
                String propertyName = (String)updatedPropertyIt.next();
                Element propertyElement = this.getUpdatedProperty(componentId, propertyName);
                Class propertyClass = componentPeer.getInputPropertyClass(propertyName);
                if (propertyClass == null) continue;
                SerialPropertyPeer propertyPeer = propertyPeerFactory.getPeerForProperty(propertyClass);
                if (propertyPeer == null) {
                    Log.log((String)("No peer available for property: " + propertyName + " of class: " + propertyClass));
                    continue;
                }
                try {
                    Object propertyValue = propertyPeer.toProperty(context, component.getClass(), propertyElement);
                    componentPeer.storeInputProperty(context, component, propertyName, -1, propertyValue);
                }
                catch (SerialException ex) {
                    throw new SynchronizationException("Unable to store input property: " + propertyName + " of class: " + propertyClass, ex);
                }
            }
        }
        if (this.getEvent() != null) {
            Component component = userInstance.getComponentByClientRenderId(this.getEventComponentId());
            ComponentSynchronizePeer componentPeer = SynchronizePeerFactory.getPeerForComponent(component.getClass());
            Class eventDataClass = componentPeer.getEventDataClass(this.getEventType());
            if (eventDataClass == null) {
                componentPeer.processEvent(context, component, this.getEventType(), null);
            } else {
                SerialPropertyPeer propertyPeer = propertyPeerFactory.getPeerForProperty(eventDataClass);
                if (propertyPeer == null) {
                    Log.log((String)("No peer available for event data for event type: " + this.getEventType() + " of class: " + eventDataClass));
                }
                try {
                    Object eventData = propertyPeer.toProperty(context, component.getClass(), this.getEvent());
                    componentPeer.processEvent(context, component, this.getEventType(), eventData);
                }
                catch (SerialException ex) {
                    throw new SynchronizationException("Unable to store event data for event type: " + this.getEventType() + " of class: " + eventDataClass, ex);
                }
            }
        }
        updateManager.processClientUpdates();
    }
}

