/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.extras.webcontainer.sync.component;

import java.util.Iterator;
import nextapp.echo.app.Component;
import nextapp.echo.app.update.ClientUpdateManager;
import nextapp.echo.app.update.ServerComponentUpdate;
import nextapp.echo.app.util.Context;
import nextapp.echo.extras.app.AccordionPane;
import nextapp.echo.extras.webcontainer.service.CommonService;
import nextapp.echo.webcontainer.AbstractComponentSynchronizePeer;
import nextapp.echo.webcontainer.ServerMessage;
import nextapp.echo.webcontainer.Service;
import nextapp.echo.webcontainer.UserInstance;
import nextapp.echo.webcontainer.WebContainerServlet;
import nextapp.echo.webcontainer.service.JavaScriptService;
import nextapp.echo.webcontainer.util.ArrayIterator;
import nextapp.echo.webcontainer.util.MultiIterator;

public class AccordionPanePeer
extends AbstractComponentSynchronizePeer {
    private static final String PROPERTY_ACTIVE_TAB_ID = "activeTabId";
    private static final Service ACCORDION_PANE_SERVICE = JavaScriptService.forResources((String)"EchoExtras.AccordionPane", (String[])new String[]{"nextapp/echo/extras/webcontainer/resource/Application.AccordionPane.js", "nextapp/echo/extras/webcontainer/resource/Sync.AccordionPane.js"});

    public AccordionPanePeer() {
        this.addOutputProperty(PROPERTY_ACTIVE_TAB_ID);
        this.addEvent(new AbstractComponentSynchronizePeer.EventPeer("tabSelect", "tabSelectionListeners", String.class){

            public boolean hasListeners(Context context, Component component) {
                return ((AccordionPane)component).hasTabSelectionListeners();
            }

            public void processEvent(Context context, Component component, Object eventData) {
                AccordionPane accordionPane = (AccordionPane)component;
                Integer tabIndex = AccordionPanePeer.this.getTabIndex(context, accordionPane, (String)eventData);
                ClientUpdateManager clientUpdateManager = (ClientUpdateManager)context.get(class$nextapp$echo$app$update$ClientUpdateManager == null ? (class$nextapp$echo$app$update$ClientUpdateManager = AccordionPanePeer.class$("nextapp.echo.app.update.ClientUpdateManager")) : class$nextapp$echo$app$update$ClientUpdateManager);
                clientUpdateManager.setComponentAction(component, "tabSelect", (Object)tabIndex);
            }
        });
    }

    public String getClientComponentType(boolean mode) {
        return "Extras.AccordionPane";
    }

    public Class getComponentClass() {
        return AccordionPane.class;
    }

    public Class getInputPropertyClass(String propertyName) {
        if (PROPERTY_ACTIVE_TAB_ID.equals(propertyName)) {
            return String.class;
        }
        return super.getInputPropertyClass(propertyName);
    }

    public Object getOutputProperty(Context context, Component component, String propertyName, int propertyIndex) {
        if (PROPERTY_ACTIVE_TAB_ID.equals(propertyName)) {
            AccordionPane accordionPane = (AccordionPane)component;
            int componentCount = accordionPane.getVisibleComponentCount();
            if (componentCount == 0) {
                return null;
            }
            int activeTabIndex = accordionPane.getActiveTabIndex();
            Component activeTab = activeTabIndex == -1 ? accordionPane.getVisibleComponent(0) : (activeTabIndex < componentCount ? accordionPane.getVisibleComponent(activeTabIndex) : accordionPane.getVisibleComponent(componentCount - 1));
            UserInstance userInstance = (UserInstance)context.get(UserInstance.class);
            return userInstance.getClientRenderId(activeTab);
        }
        return super.getOutputProperty(context, component, propertyName, propertyIndex);
    }

    private Integer getTabIndex(Context context, AccordionPane accordionPane, String clientRenderId) {
        UserInstance userInstance = (UserInstance)context.get(UserInstance.class);
        Component[] children = accordionPane.getVisibleComponents();
        for (int i = 0; i < children.length; ++i) {
            if (!userInstance.getClientRenderId(children[i]).equals(clientRenderId)) continue;
            return new Integer(i);
        }
        return null;
    }

    public Iterator getUpdatedOutputPropertyNames(Context context, Component component, ServerComponentUpdate update) {
        Iterator normalPropertyIterator = super.getUpdatedOutputPropertyNames(context, component, update);
        if (update.hasUpdatedProperty("activeTabIndex") || update.hasAddedChildren() || update.hasRemovedChildren()) {
            return new MultiIterator(new Iterator[]{normalPropertyIterator, new ArrayIterator((Object[])new String[]{PROPERTY_ACTIVE_TAB_ID})});
        }
        return normalPropertyIterator;
    }

    public void init(Context context, Component component) {
        super.init(context, component);
        ServerMessage serverMessage = (ServerMessage)context.get(ServerMessage.class);
        serverMessage.addLibrary(CommonService.INSTANCE.getId());
        serverMessage.addLibrary(ACCORDION_PANE_SERVICE.getId());
    }

    public void storeInputProperty(Context context, Component component, String propertyName, int index, Object newValue) {
        if (PROPERTY_ACTIVE_TAB_ID.equals(propertyName)) {
            ClientUpdateManager clientUpdateManager = (ClientUpdateManager)context.get(ClientUpdateManager.class);
            clientUpdateManager.setComponentProperty(component, "activeTabIndex", (Object)this.getTabIndex(context, (AccordionPane)component, (String)newValue));
        }
    }

    static {
        WebContainerServlet.getServiceRegistry().add(ACCORDION_PANE_SERVICE);
    }
}

